% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sql.R
\name{dropEmulatedTempTables}
\alias{dropEmulatedTempTables}
\title{Drop all emulated temp tables.}
\usage{
dropEmulatedTempTables(
  connection,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema")
)
}
\arguments{
\item{connection}{The connection to the database server created using either
\code{\link[=connect]{connect()}} or \code{\link[=dbConnect]{dbConnect()}}.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support temp tables. To
emulate temp tables, provide a schema with write privileges where temp tables
can be created.}
}
\value{
Invisibly returns the list of deleted emulated temp tables.
}
\description{
On some DBMSs, like Oracle and BigQuery, \code{DatabaseConnector} through \code{SqlRender} emulates temp tables
in a schema provided by the user. Ideally, these tables are deleted by the application / R script creating them,
but for various reasons orphan temp tables may remain. This function drops all emulated temp tables created in this
session only.
}
