/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.databaseConnector;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;

public class BatchedInsert {
    public static int INTEGER = 0;
    public static int NUMERIC = 1;
    public static int STRING = 2;
    public static int DATE = 3;
    public static int DATETIME = 4;
    public static int BIGINT = 5;
    private static String SPARK = "spark";
    private static String SNOWFLAKE = "snowflake";
    private static String BIGQUERY = "bigquery";
    public static final int BIG_DATA_BATCH_INSERT_LIMIT = 1000;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private Object[] columns;
    private int[] columnTypes;
    private Connection connection;
    private String dbms;
    private int columnCount;
    private int rowCount;
    private String sql;

    public BatchedInsert(Connection connection, String dbms, String sql, int columnCount) throws SQLException {
        this.connection = connection;
        this.dbms = dbms;
        this.sql = sql;
        this.columnCount = columnCount;
        this.columns = new Object[columnCount];
        this.columnTypes = new int[columnCount];
    }

    private void trySettingAutoCommit(boolean value) throws SQLException {
        if (this.dbms.equals(SPARK)) {
            return;
        }
        try {
            this.connection.setAutoCommit(value);
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    private void checkColumns() {
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == null) {
                throw new RuntimeException("Column " + (i + 1) + " not set");
            }
            if (this.columnTypes[i] == INTEGER ? ((int[])this.columns[i]).length != this.rowCount : (this.columnTypes[i] == NUMERIC ? ((double[])this.columns[i]).length != this.rowCount : (this.columnTypes[i] == BIGINT ? ((long[])this.columns[i]).length != this.rowCount : ((String[])this.columns[i]).length != this.rowCount))) {
                throw new RuntimeException("Column " + (i + 1) + " data not of correct length");
            }
            ++i;
        }
    }

    private void setValue(PreparedStatement statement, int statementIndex, int rowIndex, int columnIndex) throws SQLException, ParseException {
        if (this.columnTypes[columnIndex] == INTEGER) {
            int value = ((int[])this.columns[columnIndex])[rowIndex];
            if (value == Integer.MIN_VALUE) {
                statement.setObject(statementIndex, null);
            } else {
                statement.setInt(statementIndex, value);
            }
        } else if (this.columnTypes[columnIndex] == NUMERIC) {
            double value = ((double[])this.columns[columnIndex])[rowIndex];
            if (Double.isNaN(value)) {
                statement.setObject(statementIndex, null);
            } else {
                statement.setDouble(statementIndex, value);
            }
        } else if (this.columnTypes[columnIndex] == DATE) {
            String value = ((String[])this.columns[columnIndex])[rowIndex];
            if (value == null) {
                statement.setObject(statementIndex, null);
            } else {
                statement.setDate(statementIndex, java.sql.Date.valueOf(value));
            }
        } else if (this.columnTypes[columnIndex] == DATETIME) {
            String value = ((String[])this.columns[columnIndex])[rowIndex];
            if (value == null) {
                statement.setObject(statementIndex, null);
            } else if (this.dbms.equals(SNOWFLAKE)) {
                BatchedInsert.setTimestampForSnowflake(statement, statementIndex, value);
            } else {
                statement.setTimestamp(statementIndex, Timestamp.valueOf(value));
            }
        } else if (this.columnTypes[columnIndex] == BIGINT) {
            long value = ((long[])this.columns[columnIndex])[rowIndex];
            if (value == Long.MIN_VALUE) {
                statement.setObject(statementIndex, null);
            } else {
                statement.setLong(statementIndex, value);
            }
        } else {
            String value = ((String[])this.columns[columnIndex])[rowIndex];
            if (value == null) {
                statement.setObject(statementIndex, null);
            } else {
                statement.setString(statementIndex, value);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean executeBatch() throws SQLException, ParseException {
        if (this.dbms.equals(BatchedInsert.BIGQUERY)) {
            return this.executeBigQueryBatch();
        }
        this.checkColumns();
        try {
            this.trySettingAutoCommit(false);
            statement = this.connection.prepareStatement(this.sql);
            i = 0;
            while (i < this.rowCount) {
                j = 0;
                while (j < this.columnCount) {
                    this.setValue(statement, j + 1, i, j);
                    ++j;
                }
                statement.addBatch();
                ++i;
            }
            statement.executeBatch();
            if (!this.dbms.equals(BatchedInsert.SPARK)) {
                this.connection.commit();
            }
            statement.close();
            this.connection.clearWarnings();
            this.trySettingAutoCommit(true);
        }
        finally {
            i = 0;
            ** while (i < this.columnCount)
        }
lbl-1000:
        // 1 sources

        {
            this.columns[i] = null;
            ++i;
            continue;
        }
lbl31:
        // 1 sources

        this.rowCount = 0;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean executeBigQueryBatch() throws SQLException, ParseException {
        this.checkColumns();
        try {
            this.trySettingAutoCommit(false);
            offset = 0;
            while (offset < this.rowCount) {
                size = Math.min(this.rowCount - offset, 1000);
                params = String.join((CharSequence)",", Collections.nCopies(this.columnCount, "?"));
                sqlWithValues = String.valueOf(this.sql) + "," + String.join((CharSequence)",", Collections.nCopies(size - 1, String.format("(%s)", new Object[]{params})));
                statement = this.connection.prepareStatement(sqlWithValues);
                i = 0;
                while (i < size) {
                    j = 0;
                    while (j < this.columnCount) {
                        statementIndex = this.columnCount * i + j + 1;
                        rowIndex = offset + i;
                        this.setValue(statement, statementIndex, rowIndex, j);
                        ++j;
                    }
                    ++i;
                }
                statement.executeUpdate();
                statement.close();
                this.connection.clearWarnings();
                this.trySettingAutoCommit(true);
                offset += 1000;
            }
        }
        finally {
            i = 0;
            ** while (i < this.columnCount)
        }
lbl-1000:
        // 1 sources

        {
            this.columns[i] = null;
            ++i;
            continue;
        }
lbl35:
        // 1 sources

        this.rowCount = 0;
        return true;
    }

    private static long[] convertFromInteger64ToLong(double[] value) {
        long[] result = new long[value.length];
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 * value.length);
        int i = 0;
        while (i < value.length) {
            byteBuffer.putDouble(value[i]);
            ++i;
        }
        byteBuffer.flip();
        i = 0;
        while (i < value.length) {
            result[i] = byteBuffer.getLong();
            ++i;
        }
        return result;
    }

    public static boolean validateInteger64(double[] value) {
        long[] integers = BatchedInsert.convertFromInteger64ToLong(value);
        boolean result = integers[0] == 1L & integers[1] == -1L & integers[2] == (long)Math.pow(2.0, 33.0) & integers[3] == (long)Math.pow(-2.0, 33.0);
        return result;
    }

    public void setInteger(int columnIndex, int[] column) {
        this.columns[columnIndex - 1] = column;
        this.columnTypes[columnIndex - 1] = INTEGER;
        this.rowCount = column.length;
    }

    public void setNumeric(int columnIndex, double[] column) {
        this.columns[columnIndex - 1] = column;
        this.columnTypes[columnIndex - 1] = NUMERIC;
        this.rowCount = column.length;
    }

    public void setDate(int columnIndex, String[] column) {
        this.columns[columnIndex - 1] = column;
        this.columnTypes[columnIndex - 1] = DATE;
        this.rowCount = column.length;
    }

    public void setDateTime(int columnIndex, String[] column) {
        this.columns[columnIndex - 1] = column;
        this.columnTypes[columnIndex - 1] = DATETIME;
        this.rowCount = column.length;
    }

    public void setBigint(int columnIndex, double[] column) {
        this.columns[columnIndex - 1] = BatchedInsert.convertFromInteger64ToLong(column);
        this.columnTypes[columnIndex - 1] = BIGINT;
        this.rowCount = column.length;
    }

    public void setString(int columnIndex, String[] column) {
        this.columns[columnIndex - 1] = column;
        this.columnTypes[columnIndex - 1] = STRING;
        this.rowCount = column.length;
    }

    public void setInteger(int columnIndex, int column) {
        this.setInteger(columnIndex, new int[]{column});
    }

    public void setNumeric(int columnIndex, double column) {
        this.setNumeric(columnIndex, new double[]{column});
    }

    public void setDate(int columnIndex, String column) {
        this.setDate(columnIndex, new String[]{column});
    }

    public void setDateTime(int columnIndex, String column) {
        this.setDateTime(columnIndex, new String[]{column});
    }

    public void setString(int columnIndex, String column) {
        this.setString(columnIndex, new String[]{column});
    }

    public void setBigint(int columnIndex, double column) {
        this.setBigint(columnIndex, new double[]{column});
    }

    private static void setTimestampForSnowflake(PreparedStatement statement, int statementIndex, String value) throws ParseException, SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = sdf.parse(value);
        statement.setTimestamp(statementIndex, new Timestamp(date.getTime()));
    }
}

