% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbGetQuery,DatabaseConnectorConnection,character-method}
\alias{dbGetQuery,DatabaseConnectorConnection,character-method}
\title{Send query, retrieve results and then clear result set}
\usage{
\S4method{dbGetQuery}{DatabaseConnectorConnection,character}(conn, statement,
  ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbGetQuery()} always returns a \link{data.frame}
with as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
An error is raised when issuing a query over a closed
or invalid connection,
if the syntax of the query is invalid,
or if the query is not a non-\code{NA} string.
If the \code{n} argument is not an atomic whole number
greater or equal to -1 or Inf, an error is raised,
but a subsequent call to \code{dbGetQuery()} with proper \code{n} argument succeeds.
}
\description{
Returns the result of a query as a data frame.
\code{dbGetQuery()} comes with a default implementation
(which should work with most backends) that calls
\code{\link[=dbSendQuery]{dbSendQuery()}}, then \code{\link[=dbFetch]{dbFetch()}}, ensuring that
the result is always free-d by \code{\link[=dbClearResult]{dbClearResult()}}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbGetQuery")}
}
\details{
This method is for \code{SELECT} queries only
(incl. other SQL statements that return a \code{SELECT}-alike result,
e. g. execution of a stored procedure).

To execute a stored procedure that does not return a result set,
use \code{\link[=dbExecute]{dbExecute()}}.

Some backends may
support data manipulation statements through this method for compatibility
reasons.  However, callers are strongly advised to use
\code{\link[=dbExecute]{dbExecute()}} for data manipulation statements.
}
\seealso{
For updates: \code{\link[=dbSendStatement]{dbSendStatement()}} and \code{\link[=dbExecute]{dbExecute()}}.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbAppendTable}}, \code{\link{dbCreateTable}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbIsReadOnly}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListObjects}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}},
  \code{\link{dbWriteTable}}
}
