% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_columns.r
\name{drop_columns}
\alias{drop_columns}
\title{Drop selected variables}
\usage{
drop_columns(data, ind)
}
\arguments{
\item{data}{input data}

\item{ind}{a vector of either names or column positions of the variables to be dropped.}
}
\description{
Quickly drop variables by either column names or positions.
}
\details{
\bold{This function updates \link{data.table} object directly.} Otherwise, output data will be returned matching input object class.
}
\examples{
# Load packages
library(data.table)

# Generate data
dt <- data.table(sapply(setNames(letters, letters), function(x) {assign(x, rnorm(10))}))
dt2 <- copy(dt)

# Drop variables by name
names(dt)
drop_columns(dt, letters[2L:25L])
names(dt)

# Drop variables by column position
names(dt2)
drop_columns(dt2, seq(2, 25))
names(dt2)

# Return from non-data.table input
df <- data.frame(sapply(setNames(letters, letters), function(x) {assign(x, rnorm(10))}))
drop_columns(df, letters[2L:25L])
}
\keyword{drop_columns}
