% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp7.power.R
\name{Chapter07_power}
\alias{Chapter07_power}
\alias{power_z}
\title{Chapter 7: Power Curve}
\usage{
power_z(
  x,
  null.value,
  sd,
  n,
  alternative = c("two.sided", "less", "greater"),
  sig.level = 0.05
)
}
\arguments{
\item{x}{\link[base]{numeric} \link[base]{vector}, mean parameter(s) \eqn{\mu_1} in the alternative hypothesis}

\item{null.value}{\link[base]{numeric} scalar, mean parameter \eqn{\mu_0} in the null hypothesis}

\item{sd}{\link[base]{numeric} scalar, population standard deviation \eqn{\sigma}}

\item{n}{\link[base]{integer} scalar, sample size \eqn{n}}

\item{alternative}{\link[base]{character} scalar, alternative hypothesis,
either \code{'two.sided'} (default), \code{'greater'} or \code{'less'}}

\item{sig.level}{\link[base]{numeric} scalar, significance level (i.e., Type-I-error rate), default \eqn{.05}}
}
\value{
Function \link{power_z} returns a \code{'power_z'} object,
which inherits from \code{'power.htest'} class.
}
\description{
Functions for Chapter 7, \emph{Hypothesis Testing}.
}
\details{
Function \link{power_z} calculates the powers at each element of the alternative parameters \eqn{\mu_1}, for one-sample \eqn{z}-test
\itemize{
\item{\eqn{H_0: \mu = \mu_0} vs. \eqn{H_A: \mu \neq \mu_0}, if \code{alternative = 'two.sided'}}
\item{\eqn{H_0: \mu \leq \mu_0} vs. \eqn{H_A: \mu > \mu_0}, if \code{alternative = 'greater'}}
\item{\eqn{H_0: \mu \geq \mu_0} vs. \eqn{H_A: \mu < \mu_0}, if \code{alternative = 'less'}}
}
}
\examples{
library(DanielBiostatistics10th)
library(ggplot2)

# Example 7.9.1; Page 272 (10th ed), Page 245 (11th ed) 
(p791 = power_z(seq.int(from = 16, to = 19, by = .5), null.value = 17.5, sd = 3.6, n = 100L))
# Table 7.9.1
autoplot(p791) + labs(title = 'Figure 7.9.2')

# Example 7.9.2; Page 276 (10th ed), Page 248 (11th ed) 
(p792 = power_z(seq.int(from = 50, to = 70, by = 5), null.value = 65, sd = 15, n = 20L, 
                sig.level = .01, alternative = 'less'))
autoplot(p792) + labs(title = 'Figure 7.9.4')

# Example 7.10.1; Page 278, 
(n_d7101 <- uniroot(f = function(x) {
  power_z(55, null.value = 65, sd = 15, n = x, sig.level = .01, alternative = 'less')$power - .95
}, interval = c(0, 50))$root)
power_z(55, null.value = 65, sd = 15, n = ceiling(n_d7101), sig.level = .01, alternative = 'less')
}
\seealso{
\link[stats]{power.t.test}
}
