% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_raincloud.R
\name{plot_raincloud}
\alias{plot_raincloud}
\title{Generate raincloud plot}
\usage{
plot_raincloud(max_min_values_list, D)
}
\arguments{
\item{max_min_values_list}{A list generated by \code{\link[=get_max_min_values]{get_max_min_values()}} that
must contain at least two elements.}

\item{D}{A single threshold value.}
}
\value{
A raincloud plot for peak (or minimum) values
}
\description{
The probability densities of the highest (or lowest if the
threshold is a minimum) projected outcome across simulation runs are
plotted for each policy alternative alongside corresponding box plots,
which indicate the mean and 50th percentile range. These plots are
presented collectively on a single graph to facilitate visual comparison
of the policy alternatives. The decision threshold is shown directly on
the plot as a vertical line to provide a clear reference point for
interpreting the outputs.
}
\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
D <- 750

peak_values_list <- get_max_min_values(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt_max = TRUE
)

plot_raincloud(
  peak_values_list,
  D = D
)
}
