% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_7FA2.R
\name{compute.fa2}
\alias{compute.fa2}
\title{FA2}
\usage{
compute.fa2(Y, X, verbose = F)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}

\item{verbose}{if TRUE, print advice about the quality of the model}
}
\description{
Estimates the FA2 of two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the value of FA2 of two vectors corresponding to univariate signals X (true values) and Y (imputed values).
This FA2 corresponds to the percentage of pairs of values (\eqn{x_{i}, y_{i}}) satisfying the condition \eqn{0,5 <= (Y_{i}/X_{i}) <= 2}.
The closer FA2 is to 1, the more accurate is the imputation model.
Both vectors Y and X must be of equal length, on the contrary an error will be displayed.
In both input vectors, eventual NA will be exluded with a warning diplayed.
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1] ; Y <- dataDTWBI[, 2]
compute.fa2(Y,X)
compute.fa2(Y,X, verbose = TRUE)

# By definition, if pairs of true and imputed values are zero,
# FA2 corresponding to this pair of values equals 1.
X[1] <- 0
Y[1] <- 0
compute.fa2(Y,X)
}
\author{
DEZECACHE Camille, PHAN Thi Thu Hong, POISSON-CAILLAULT Emilie
}
