% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTAT-package.R
\docType{data}
\name{sim}
\alias{sim}
\title{Environment for simulation global variables.}
\description{
To simplify the code of package DTAT, as well as client tasks, this exported
environment contains a handful of global variables useful for the
simulations.
}
\details{
Global variables maintained within environment \code{sim} are:
\enumerate{
\item \code{pkpd}: The population PK/PD model to be simulated.
\item \code{pop}: A sample drawn from the population model.
\item \code{N}: Restricts simulation to first \code{N} subjects in
\code{pop}.
\item \code{inits_fac}: An initializer factory taking an initial state as
argument.
\item \code{params.default}: Default parameters.
}
}
\examples{

# Even when nrow(pop) is large, one may easily restrict
# time-consuming simulations to pop[1:N,], as follows:
sim$N <- 25
# Now perform simulation work
\dontrun{
titrate(...)
}

}
\keyword{datasets}
