% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaultDSConfiguration.R
\name{defaultDSConfiguration}
\alias{defaultDSConfiguration}
\title{Default DataSHIELD configuration}
\usage{
defaultDSConfiguration(include = NULL, exclude = NULL)
}
\arguments{
\item{include}{Character vector of package names to be explicitly included. If NULL, do not filter packages.}

\item{exclude}{Character vector of package names to be explicitly excluded. If NULL, do not filter packages.}
}
\description{
Find the R packages that have DataSHIELD server configuration information in them
and extract this information in a data frame of aggregation/assignment methods and a named list
of R options. The DataSHIELD packages can be filtered by specifying explicitly the package names
to be included or excluded. The package exclusion prevails over the inclusion.
}
\examples{
{
# detect DS packages
defaultDSConfiguration()
# exclude a DS package
defaultDSConfiguration(exclude="dsBase")
# include explicitely some DS packages
defaultDSConfiguration(include=c("dsBase", "dsOmics"))
}

}
