% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.assign.R
\name{datashield.assign.resource}
\alias{datashield.assign.resource}
\title{Resource assignment}
\usage{
datashield.assign.resource(conns, symbol, resource, async = TRUE)
}
\arguments{
\item{conns}{\code{\link{DSConnection-class}} object or a list of \code{\link{DSConnection-class}}s.}

\item{symbol}{Name of the R symbol.}

\item{resource}{Fully qualified name of a resource reference in the data repository (can be a vector or must be
the same in each data repository); or a named list of fully qualified resource names (one per server
name); or a data frame with 'server' and 'resource' columns (such as the one that is used in
\code{\link{datashield.login}})}

\item{async}{Whether the result of the call should be retrieved asynchronously. When TRUE (default) the calls are parallelized over
the connections, when the connection supports that feature, with an extra overhead of requests.}
}
\description{
Assign a resource object of class 'ResourceClient' to a R symbol in the Datashield R session.
}
\examples{
\dontrun{
# assign a resource HOP
datashield.assign.resource(conn, symbol="rsrc", resource="demo.HOP")

# assign the tables that are defined in the logindata ('server' and 'resource' columns are
# expected) data frame that is used in datashield.login() function. Connections names
# and server names must match.
datashield.assign.resource(conns, "rsrc", logindata)

# assign the resources that are defined in the provided named list. 
# Connections are filtered by the list names.
datashield.assign.resource(conns, "rsrc",
  list(server1="datashield.CNSIM1", server2="datashield.CNSIM2"))
}
}
