% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsAssignExpr}
\alias{dsAssignExpr}
\title{Assign an expression result}
\usage{
dsAssignExpr(conn, symbol, expr, async = TRUE)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}

\item{symbol}{Name of the R symbol.}

\item{expr}{A R expression with allowed assign functions calls.}

\item{async}{Whether the result of the call should be retrieved asynchronously. When TRUE (default) the calls are parallelized over
the connections, when the connection supports that feature, with an extra overhead of requests.}
}
\description{
Assign the result of the evaluation of an expression to a symbol the DataSHIELD R session
The assignment expression must satisfy the data repository's DataSHIELD configuration.

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsAssignExpr")}
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "username", "password", "https://opal.example.org")
dsAssignExpr(con, "C", as.symbol("c(1, 2, 3)"))
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
