% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_sirdemographic_stochastic.R
\name{simulate_sirdemographic_stochastic}
\alias{simulate_sirdemographic_stochastic}
\title{Stochastic simulation of an SIR-type model with births and deaths}
\usage{
simulate_sirdemographic_stochastic(S = 1000, I = 10, R = 0,
  b = 0.001, g = 0.5, m = 0, n = 0, tmax = 100, rngseed = 100)
}
\arguments{
\item{S}{: initial number of susceptible hosts : numeric}

\item{I}{:  initial number of infected, symptomatic hosts : numeric}

\item{R}{:  initial number of recovered hosts : numeric}

\item{b}{: level/rate of infectiousness for hosts in the I compartment : numeric}

\item{g}{: rate at which a person leaves the I compartment : numeric}

\item{m}{: the rate at which new individuals enter the model (are born) : numeric}

\item{n}{: the rate of natural death (the inverse is the average lifespan) : numeric}

\item{tmax}{: maximum simulation time : numeric}

\item{rngseed}{: seed for random number generator to allow reproducibility : numeric}
}
\value{
The function returns a list. The list has one element, a data frame ts
which contains the time series of the simulated model, 
with one column per compartment/variable. The first column is time.
}
\description{
Simulation of a stochastic SIR type model with the following
  compartments: Susceptibles (S), 
  Infected and Infectious (I), Recovered and Immune (R)
}
\details{
A compartmental SIR model is
  simulated. Units of
  time depend on the time units chosen for model parameters. The simulation
  runs as a stochastic model using the adaptive-tau algorithm as implemented
  by ssa.adaptivetau in the adpativetau package. See the manual of this
  package for more details. The function returns a list,
  with the time series of the
  simulated disease as list element ts, with one column per
  compartment/variable. The first column is time.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter values
  or fractions > 1), the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters, just call the function:
result <- simulate_sirdemographic_stochastic()
# To choose parameter values other than the standard one, specify them like this:
result <- simulate_sirdemographic_stochastic(S = 2000,  tmax = 200, b = 0.01)
# You can display or further process the result, like this:
plot(result$ts[,'time'],result$ts[,'S'],xlab='Time',ylab='Number Susceptible',type='l')
print(paste('Max number of infected: ',max(result$ts[,'I']))) 
}
\seealso{
See the Shiny app documentation corresponding to this simulator
function for more details on this model. See the manual for the adaptivetau
package for details on the stochastic algorithm.
}
\author{
Andreas Handel
}
