\name{dbCompare}
\alias{dbCompare}
\title{Compare DNA profiles}
\description{
  Compare DNA profiles
}
\usage{
dbCompare(x, profiles=NULL, hit=7, trace=TRUE, vector=FALSE, collapse=FALSE,
          wildcard=FALSE,wildcard.effect=FALSE, wildcard.impose=FALSE,
          Rallele=FALSE, threads=2)
}
\arguments{
  \item{x}{Database with DNA profiles. The database format is expected
    to be a data frame with each column containing an allelic number
    such that for each DNA marker there are two columns in the data
    frame. See \code{data(dbExample)} for an example of the format.}
  \item{profiles}{One or more profiles to be compared with all profiles in
    the database. Input is a vector, matrix or data frame of same
    length/width as a row in the database \code{x}.
    If profiles is non-null only one CPU will be used. In case threads>1
    a warning will be given but computations performed using single core.}
  \item{hit}{The number of matching loci for further investigation}
  \item{trace}{Shows a progress bar}
  \item{vector}{Logical. Whether the result should be returned as vector
    or a matrix. Note if 'collapse' is TRUE vector is ignored.}
  \item{collapse}{Logical (default FALSE). If TRUE the
    (m,p)-matrix will be collapased into a (2*m+p)-vector containing the
    total number of matching alleles.}
  \item{wildcard}{Use the wildcard comparing.}
  \item{wildcard.effect}{Compare result of wildcard and no wildcard.}
  \item{wildcard.impose}{Force homozygouse profiles (aa) to have wildcard (aF).}
  \item{Rallele}{Implementation of 'Rare allele'designation matching.}
  \item{threads}{The number of threads to use for performing comparisons 
    in parallel for increased computation time. Use 0 for using the 
    same number as the computer has CPU cores. NOTE: Only available on 
    Linux and MacOS operating systems.}
}
\details{
  Computes the distance between DNA profiles in terms of matching and
  partially-matching STR loci.
}
\value{
  Returns a matrix with the number of pairs mathcing/partially-matching at (i,j)-loci.
}
  
\author{James Curran and Torben Tvedebrink. The multicore/CPU
  implementation was provided by Mikkel Meyer Andersen.}

\examples{
  \dontrun{
  data(dbExample)
  dbCompare(dbExample,hit=5,trace=TRUE)
  }
}


