% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMMMI.R
\name{PMMI}
\alias{PMMI}
\title{Predictive Mean Matching with Multiple Imputation}
\usage{
PMMI(data, k = 5, m = 5)
}
\arguments{
\item{data}{Dataframe with response variable in 1st column and predictors in others}

\item{k}{Number of nearest neighbors for matching (default=5)}

\item{m}{Number of imputations (default=5)}
}
\value{
List containing:
\item{Y}{Original response vector with NAs}
\item{Yhat}{Final imputed response vector (averaged across imputations)}
\item{betahat}{Pooled regression coefficients}
\item{imputations}{List of m completed datasets}
\item{m}{Number of imputations performed}
\item{k}{Number of neighbors used}
}
\description{
Implements PMM algorithm for handling missing data in linear regression models.
Uses chained equations approach to generate multiple imputed datasets and 
pools results using Rubin's rules.
}
\examples{
# Create dataset with 30\% missing values
data <- data.frame(Y=c(rnorm(70),rep(NA,30)), X1=rnorm(100))
results <- PMMI(data, k=5, m=5)
}
