#' 3D Forest Simulation Visualization Tool
#'
#' This is a visualization tool for vegetation structure/succession
#' in space and/or time mainly for forest gap models. However, it could also be used to
#' visualize observed forest stands. If used for models, they should contain either
#' individual trees or cohorts (e.g. LPJ-GUESS by Smith et al. (2014) <doi:10.5194/bg-11-2027-2014>).
#' For a list of required and additional data fields see the vignette.
#'
#' @references
#' Smith, B., Warlind, D., Arneth, A., Hickler, T., Leadley, P., Siltberg, J. and Zaehle, S.: Implications of incorporating N cycling and N limitations on primary production in an individual-based dynamic vegetation model, Biogeosciences, 11(7), 2027-2054, \href{https://dx.doi.org/10.5194/bg-11-2027-2014}{doi:10.5194/bg-11-2027-2014}, 2014.
#'
"_PACKAGE"


## to build the vignette I had to run
## devtools::build_vignettes(pkg = ".")
## by hand
