% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCors.R
\name{getCors}
\alias{getCors}
\title{Compute matrices necessary for differential correlation calculation.}
\usage{
getCors(inputMat, design, inputMatB = NULL, impute = FALSE,
  corrType = "pearson")
}
\arguments{
\item{inputMat}{The matrix (or data.frame) of values (e.g., gene expression values from an RNA-seq or microarray study) that you are interested in analyzing. The rownames of this matrix should correspond to the identifiers whose correlations and differential correlations you are interested in analyzing, while the columns should correspond to the rows of the design matrix and should be separable into your groups.}

\item{design}{A standard model.matrix created design matrix. Rows correspond to samples and colnames refer to the names of the conditions that you are interested in analyzing. Only 0's or 1's are allowed in the design matrix. Please see vignettes for more information.}

\item{inputMatB}{Optional, secondary input matrix that allows you to calculate correlation and differential correlation for the rows between inputMat and imputMatB.}

\item{impute}{A binary variable specifying whether values should be imputed if there are missing values. Note that the imputation is performed in the full input matrix (i.e., prior to subsetting) and uses k-nearest neighbors.}

\item{corrType}{The correlation type of the analysis, limited to "pearson" or "spearman". Default = "pearson".}
}
\value{
A corMats S4 class object, containing a list of matrices from each group, the design matrix, and a character vector of options.
}
\description{
As a first step in the standard DGCA workflow, this function reads in a design matrix and an input matrix, splits the input matrix by the named groups defined in the design matrix, and outputs a list of matrices (correlation matrix, correlation significance matrix, and number of samples matrix) to be used by downstream parts of the analysis.
}
\examples{
data(darmanis); data(design_mat); darmanis_subset = darmanis[1:30, ]
cors_res = getCors(inputMat = darmanis_subset, design = design_mat)
}

