% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseDCor.R
\name{pairwiseDCor}
\alias{pairwiseDCor}
\title{Calculate pairwise differential correlations.}
\usage{
pairwiseDCor(corMatsObj, compare, corr_cutoff = 0.99, corrType = "pearson",
  secondMat = FALSE, signType = "none")
}
\arguments{
\item{corMatsObj}{A class object containing a named list of lists of matrices, one list per condition, with each list containing a correlation matrix, a correlation significance p-values matrix, and a "number of samples used to calculate the correlation" matrix.}

\item{compare}{Vector of two character strings, each corresponding to one name in the list of correlation matrices that should be compared.}

\item{corr_cutoff}{Cutoff specifying correlation values beyond which will be truncated to this value, to reduce the effect of outlier correlation values when using small sample sizes.}

\item{corrType}{The correlation type of the analysis, limited to "pearson" or "spearman".}

\item{secondMat}{Logical indicator of whether there is a second matrix in the comparison or not.}

\item{signType}{Coerce all correlation coefficients to be either positive (via "positive"), negative (via "negative"), or none (via "none"). This could be used if you think that going from a positive to a negative correlation is unlikely to occur biologically and is more likely to be due to noise, and you want to ignore these effects. Note that this does NOT affect the reported underlying correlation values, but does affect the z-score difference of correlation calculation. Default = "none", for no coercing.}
}
\value{
A dcPair class object, containing the difference in z scores for each comparison, the p-values of that differences, and the original correlation matrices and significances for subsequent classification steps.
}
\description{
Find the differential correlation between two conditions.
}

