% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCors.R
\name{plotCors}
\alias{plotCors}
\title{Plot gene pair correlations in multiple conditions.}
\usage{
plotCors(inputMat, design, compare, corrType = "pearson", geneA, geneB,
  oneRow = FALSE, smooth = TRUE, log = FALSE, ylab = NULL,
  xlab = NULL)
}
\arguments{
\item{inputMat}{The matrix (or data.frame) of values (e.g., gene expression values from an RNA-seq or microarray study) that you are interested in analyzing. The rownames of this matrix should correspond to the identifiers whose correlations and differential correlations you are interested in analyzing, while the columns should correspond to the rows of the design matrix and should be separable into your groups.}

\item{design}{A standard model.matrix created design matrix. Rows correspond to samples and colnames refer to the names of the conditions that you are interested in analyzing. Only 0's or 1's are allowed in the design matrix. Please see vignettes for more information.}

\item{compare}{Vector of two character strings, each corresponding to one group name in the design matrix, that should be compared.}

\item{corrType}{The correlation type of the analysis, limited to "pearson" or "spearman". Default = "pearson".}

\item{geneA}{The first gene symbol.}

\item{geneB}{The second gene symbol.}

\item{oneRow}{Coerce all of the conditions to be plotted on the same row (as opposed to wrapping to multiple rows; relevant if there are >3 conditions).}

\item{smooth}{Whether to perform lm-based smoothing of the trend in each condition and add this to the plot.}

\item{log}{Logical, indicating whether the data should be log2-transformed prior to plotting (after adding a small constant of 0.5 to avoid problems with the log transform).}

\item{ylab}{Override the y-axis label to one of your choice.}

\item{xlab}{Override the x-axis label to one of your choice.}
}
\value{
A ggplot2 object that can be plotted, further modified, and/or saved.
}
\description{
Takes the original input matrix, a design matrix, and two gene symbols to plot the corelation in the conditions specified.
}

