% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.DET}
\alias{plot.DET}
\title{DET Curve plot}
\usage{
\method{plot}{DET}(x, ...)
}
\arguments{
\item{x}{An object of class "DET".}

\item{...}{Further graphical arguments passed to the \code{plot} function.}
}
\description{
From a 'DET' object, this function plots the DET curve included in the object.
}
\examples{
library(DET)
n = 5000
#Predictors with normal distribution
set.seed(1235)
scoreNegative = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(11452)
scorePositive = rnorm(n, mean = 0.55, sd = 0.125)
response = as.factor(c(rep(c("target"), times = n), rep(c("nontarget"), times = n)))
predictor = matrix(c(scoreNegative, scorePositive), ncol = 1)
colnames(predictor) = c("DET")
detCurve = detc(response,
                predictor,
                names = colnames(predictor),
                positive = "target")
plot(detCurve@detCurves$DET,
     main = "Example")
}
