% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a-misc.R
\name{make.windfarms}
\alias{make.windfarms}
\title{Make wind farm construction scenario}
\usage{
make.windfarms(
  area.file,
  area.def,
  n.wf,
  n.turb,
  turb.dist,
  min.wf.dist,
  impact,
  constr.start,
  constr.end,
  constr.time,
  constr.break,
  iterate = 10000,
  verbose = FALSE,
  wf.coords = "random"
)
}
\arguments{
\item{area.file}{Name of the raster file specifying where the wind farms
should be constructed.}

\item{area.def}{Value in \code{area.file} for the areas were wind farms can
be located}

\item{n.wf}{Number of wind farms to construct}

\item{n.turb}{Total number of turbines to construct}

\item{turb.dist}{Distance between turbines within a wind farm (meters)}

\item{min.wf.dist}{Minimum distance between wind farms (meters)}

\item{impact}{Sound source level (dB); sound emitted from turbines during
construction, i.e. from tickStart to tickEnd (including both start and end)}

\item{constr.start}{The tick at which construction of the first turbine starts.}

\item{constr.end}{The tick at which construction of the very last turbine in
the last wind farm ends.}

\item{constr.time}{The time it takes to construct a single wind turbine
(number of ticks).}

\item{constr.break}{Break between individual pilings within a wind farm,
counted in number of half-hour 'ticks'.}

\item{iterate}{Number of times to try finding a spot for a new wind farm that
is sufficiently far from the nearest neighbouring wind farm (>min.wf.dist).
The number also defines the number of random positions to search through.}

\item{verbose}{Logical; whether messages should be printed to console.}

\item{wf.coords}{Possible location of the south-western corner of the wind
farms. Defaults to the text "random", but can also be a data frame with
coordinates in the columns x and y.}
}
\value{
data.frame specifying the position of each turbine in a wind farm,
along with the start time and end time for pile driving of the turbine
foundation and the sound source level during pile driving. Can be
exported as a text file and used for controlling DEPONS simulations.
}
\description{
Produce a hypothetical wind farm construction scenario, specifying
the position and timing of individual piling events, as well as the sound
source level. All wind farms are assumed to consist of the same number of
turbines, laid out in a rectangular grid. The start and end tick (i.e. the
number of half-hour intervals since simulation start) is generated based on
provided values for the time it required for each piling and the time between
piling events.
}
\note{
The parameters \code{constr.start}, \code{constr.end}, \code{constr.time},
and \code{constr.break} are truncated to nearest integer value. Construction
of wind farms starts in WF001 at tick \code{constr.start}. Each turbine
foundation is piled over a period of \code{constr.time}, followed by a
noise-free period of \code{constr.break}. Several pile driving operations may
take place at the same time, to ensure that the last piling ends before \code{constr.end}.
}
