% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEET_plot_correlation.R
\name{DEET_plot_correlation}
\alias{DEET_plot_correlation}
\title{DEET_plot_correlation}
\usage{
DEET_plot_correlation(correlation_input)
}
\arguments{
\item{correlation_input}{The "DE_correlations" element of the
output of the DEET_enrich function. This function only works if
there is at least one significantly correlated study.}
}
\value{
Named list of ggplot objects with the correlation between
the input study and the study within DEET
}
\description{
Take significant correlation outputs and generate
scatterplots of the genes DE in one or the other.
}
\examples{
\donttest{

data("example_DEET_enrich_input")
data("DEET_example_data")
DEET_out <- DEET_enrich(example_DEET_enrich_input, DEET_dataset = DEET_example_data)
correlation_input <- DEET_out$DE_correlations
correlation_plots <- DEET_plot_correlation(correlation_input)

}

}
\author{
Dustin Sokolowski, Jedid Ahn
}
