% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recodeMissings.R
\name{recodeMissings}
\alias{recodeMissings}
\title{Consistent recoding of (extended) missing values}
\usage{
recodeMissings(
  dataset,
  to = c("SPSS", "Stata", "SAS"),
  dictionary = NULL,
  start = -91,
  ...
)
}
\arguments{
\item{dataset}{A data frame}

\item{to}{Software to recode missing values for}

\item{dictionary}{A named vector, with corresponding Stata missing codes to SPSS missing values}

\item{start}{A named vector, with corresponding Stata missing codes to SPSS missing values}

\item{...}{Other internal arguments}
}
\value{
A data frame with all missing values recoded consistently.
}
\description{
A function to recode all missing values to either SPSS or Stata types,
uniformly (re)using the same codes across all variables.
}
\details{
When a dictionary is not provided, it is automatically constructed from the
available data and metadata, using negative numbers starting from -91 and up
to 27 letters starting with "a".

If the dataset contains mixed variables with SPSS and Stata style missing
values, unless otherwise specified in a dictionary it uses other codes than
the existing ones.

For the SPSS type of missing values, the resulting variables are coerced to a
declared labelled format.

Unlike SPSS, Stata does not allow labels for character values. Both cannot be
transported from SPSS to Stata, it is either one or another. If labels are
more important to preserve than original values (especially the information
about the missing values), the argument \code{chartonum} replaces all character
values with suitable, non-overlapping numbers and adjusts the labels
accordingly.

If no labels are found in the metadata, the original values are preserved.
}
\examples{
x <- data.frame(
    A = declared(
        c(1:5, -92),
        labels = c(Good = 1, Bad = 5, NR = -92),
        na_values = -92
    ),
    B = labelled(
        c(1:5, haven::tagged_na('a')),
        labels = c(DK = haven::tagged_na('a'))
    ),
    C = declared(
        c(1, -91, 3:5, -92),
        labels = c(DK = -91, NR = -92),
        na_values = c(-91, -92)
    )
)

xrec <- recodeMissings(x, to = "Stata")

attr(xrec, "dictionary")

dictionary <- data.frame(
    old = c(-91, -92, "a"),
    new = c("c", "d", "c")
)
recodeMissings(x, to = "Stata", dictionary = dictionary)

recodeMissings(x, to = "SPSS")

dictionary$new <- c(-97, -98, -97)

recodeMissings(x, to = "SPSS", dictionary = dictionary)

recodeMissings(x, to = "SPSS", start = 991)

recodeMissings(x, to = "SPSS", start = -8)

}
\author{
Adrian Dusa
}
