% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.iscluster.R
\name{glmAndZIP.iscluster}
\alias{glmAndZIP.iscluster}
\title{Obtains the cluster with the maximum log-likelihood ratio or minimum DIC
of all the clusters with the same center and start and end dates.}
\usage{
glmAndZIP.iscluster(stfdf, idxorder, minDateCluster, maxDateCluster, fractpop,
  model0, ClusterSizeContribution)
}
\arguments{
\item{stfdf}{a spatio-temporal class object containing the data.}

\item{idxorder}{a permutation of the regions according to their distance to
the current center.}

\item{minDateCluster}{start date of the cluster.}

\item{maxDateCluster}{end date of the cluster.}

\item{fractpop}{maximum fraction of the total population inside the cluster.}

\item{model0}{Initial model (including covariates).}

\item{ClusterSizeContribution}{Variable used to check the fraction of the 
population at risk in the cluster
This can be "glm" for generalized linear models (\link{glm} {stats}),
"glmer" for generalized linear mixed model (\link{glmer} {lme4}),
"zeroinfl" for zero-inflated models (\link{zeroinfl} {pscl}), or
"inla" for generalized linear, generalized linear mixed or zero-inflated models fitted with \code{inla}.}
}
\value{
vector containing the size, the start and end dates,
the log-likelihood ratio or DIC, the p-value and the risk
of the cluster with the maximum log-likelihood ratio or minimum DIC.
}
\description{
This function constructs all the clusters with start date equal to
minDateCluster, end date equal to maxDateCluster, and with center specified
by the first element of idxorder, so that the maximum fraction of the total
population inside the cluster is less than fractpop, and the maximum
distance to the center is less than radius.
For each one of these clusters, the log-likelihood ratio test statistic
for comparing the alternative model with the cluster versus the null model
of no clusters (if model is \link{glm}, \link{glmer} or \link{zeroinfl}),
or the DIC (if model is \code{inla}) is calculated.
The cluster with maximum value of the log-likelihood ratio or
minimum DIC is returned.
}
