% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweaks.R
\name{tweaks}
\alias{tweaks}
\title{Tweaks for DBI tests}
\usage{
tweaks(..., constructor_name = NULL, constructor_relax_args = FALSE,
  strict_identifier = FALSE, omit_blob_tests = FALSE,
  current_needs_parens = FALSE, union = function(x) paste(x, collapse =
  " UNION "), placeholder_pattern = NULL, logical_return = identity,
  date_cast = function(x) paste0("date('", x, "')"), time_cast = function(x)
  paste0("time('", x, "')"), timestamp_cast = function(x)
  paste0("timestamp('", x, "')"), date_typed = TRUE, time_typed = TRUE,
  timestamp_typed = TRUE, temporary_tables = TRUE)
}
\arguments{
\item{...}{\code{[any]}\cr
Unknown tweaks are accepted, with a warning.  The ellipsis
also asserts that all arguments are named.}

\item{constructor_name}{\code{[character(1)]}\cr
Name of the function that constructs the \code{Driver} object.}

\item{constructor_relax_args}{\code{[logical(1)]}\cr
If \code{TRUE}, allow a driver constructor with default values for all
arguments; otherwise, require a constructor with empty argument list
(default).}

\item{strict_identifier}{\code{[logical(1)]}\cr
Set to \code{TRUE} if the DBMS does not support arbitrarily-named
identifiers even when quoting is used.}

\item{omit_blob_tests}{\code{[logical(1)]}\cr
Set to \code{TRUE} if the DBMS does not support a \code{BLOB} data
type.}

\item{current_needs_parens}{\code{[logical(1)]}\cr
Set to \code{TRUE} if the SQL functions \code{current_date},
\code{current_time}, and \code{current_timestamp} require parentheses.}

\item{union}{\code{[function(character)]}\cr
Function that combines several subqueries into one so that the
resulting query returns the concatenated results of the subqueries}

\item{placeholder_pattern}{\code{[character]}\cr
A pattern for placeholders used in \code{\link[=dbBind]{dbBind()}}, e.g.,
\code{"?"}, \code{"$1"}, or \code{":name"}. See
\code{\link[=make_placeholder_fun]{make_placeholder_fun()}} for details.}

\item{logical_return}{\code{[function(logical)]}\cr
A vectorized function that converts logical values to the data type
returned by the DBI backend.}

\item{date_cast}{\code{[function(character)]}\cr
A vectorized function that creates an SQL expression for coercing a
string to a date value.}

\item{time_cast}{\code{[function(character)]}\cr
A vectorized function that creates an SQL expression for coercing a
string to a time value.}

\item{timestamp_cast}{\code{[function(character)]}\cr
A vectorized function that creates an SQL expression for coercing a
string to a timestamp value.}

\item{date_typed}{\code{[logical(1L)]}\cr
Set to \code{FALSE} if the DBMS doesn't support a dedicated type for dates.}

\item{time_typed}{\code{[logical(1L)]}\cr
Set to \code{FALSE} if the DBMS doesn't support a dedicated type for times.}

\item{timestamp_typed}{\code{[logical(1L)]}\cr
Set to \code{FALSE} if the DBMS doesn't support a dedicated type for
timestamps.}

\item{temporary_tables}{\code{[logical(1L)]}\cr
Set to \code{FALSE} if the DBMS doesn't support temporary tables.}
}
\description{
TBD.
}
