% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R, R/spec-driver-get-info.R,
%   R/spec-connection-connect.R, R/spec-connection-data-type.R,
%   R/spec-connection-get-info.R, R/spec-result-send-query.R,
%   R/spec-result-fetch.R, R/spec-result-get-query.R,
%   R/spec-result-create-table-with-data-type.R, R/spec-result-roundtrip.R,
%   R/spec-sql-quote-string.R, R/spec-sql-quote-identifier.R,
%   R/spec-sql-read-write-table.R, R/spec-sql-read-write-roundtrip.R,
%   R/spec-sql-list-tables.R, R/spec-sql-list-fields.R,
%   R/spec-meta-is-valid-connection.R, R/spec-meta-is-valid-result.R,
%   R/spec-meta-get-statement.R, R/spec-meta-column-info.R,
%   R/spec-meta-get-row-count.R, R/spec-meta-get-rows-affected.R,
%   R/spec-meta-get-info-result.R, R/spec-meta-bind.R,
%   R/spec-meta-bind-multi-row.R, R/spec-transaction-begin-rollback.R,
%   R/spec-transaction-with-transaction.R, R/spec-compliance-methods.R,
%   R/spec-compliance-read-only.R, R/spec-stress-driver.R,
%   R/spec-stress-connection.R
\docType{data}
\name{DBIspec-wip}
\alias{DBIspec-wip}
\title{DBI specification (work in progress)}
\description{
Placeholder page.
}
\section{Driver}{

\subsection{\code{dbGetInfo("DBIDriver")} (deprecated)}{
Return value of dbGetInfo has necessary elements.
}


\subsection{Repeated loading, instantiation, and unloading}{
Repeated load, instantiation, and unload of package in a new R session.
}
}

\section{Connection}{

\subsection{Construction: \code{dbConnect("DBIDriver")} and \code{dbDisconnect("DBIConnection", "ANY")}}{
Can connect and disconnect, connection object inherits from
"DBIConnection".
Repeated disconnect throws warning.
}


\subsection{\code{dbDataType("DBIConnection", "ANY")}}{
SQL Data types exist for all basic R data types. dbDataType() does not
throw an error and returns a nonempty atomic character
}


\subsection{\code{dbGetInfo("DBIConnection")} (deprecated)}{
Return value of dbGetInfo has necessary elements
}


\subsection{Stress tests}{
Open 50 simultaneous connections
Open and close 50 connections
Repeated load, instantiation, connection, disconnection, and unload of
package in a new R session.
}
}

\section{Result}{

\subsection{Construction: \code{dbSendQuery("DBIConnection")} and \code{dbClearResult("DBIResult")}}{
Can issue trivial query, result object inherits from "DBIResult".
Return value, currently tests that the return value is always
\code{TRUE}, and that an attempt to close a closed result set issues a
warning.
Leaving a result open when closing a connection gives a warning.
Can issue a command query that creates a table, inserts a row, and
deletes it; the result sets for these query always have "completed"
status.
Issuing an invalid query throws error (but no warnings, e.g. related to
pending results, are thrown).
}


\subsection{\code{dbFetch("DBIResult")} and \code{dbHasCompleted("DBIResult")}}{
Single-value queries can be fetched.
Multi-row single-column queries can be fetched.
Multi-row queries can be fetched progressively.
If more rows than available are fetched, the result is returned in full
but no warning is issued.
If zero rows are fetched, the result is still fully typed.
If less rows than available are fetched, the result is returned in full
but no warning is issued.
Side-effect-only queries (without return value) can be fetched.
Fetching from a closed result set raises an error.
Querying a disconnected connection throws error.
}


\subsection{\code{dbGetQuery("DBIConnection", "ANY")}}{
Single-value queries can be read with dbGetQuery
Multi-row single-column queries can be read with dbGetQuery.
Empty single-column queries can be read with
\code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}}. Not all SQL dialects support the query
used here.
Single-row multi-column queries can be read with dbGetQuery.
Multi-row multi-column queries can be read with dbGetQuery.
Empty multi-column queries can be read with
\code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}}. Not all SQL dialects support the query
used here.
}


\subsection{Create table with data type}{
SQL Data types exist for all basic R data types, and the engine can
process them.
SQL data type for factor is the same as for character.
}


\subsection{Data roundtrip}{
Data conversion from SQL to R: integer
Data conversion from SQL to R: integer with typed NULL values.
Data conversion from SQL to R: integer with typed NULL values
in the first row.
Data conversion from SQL to R: numeric.
Data conversion from SQL to R: numeric with typed NULL values.
Data conversion from SQL to R: numeric with typed NULL values
in the first row.
Data conversion from SQL to R: logical. Optional, conflict with the
\code{data_logical_int} test.
Data conversion from SQL to R: logical with typed NULL values.
Data conversion from SQL to R: logical with typed NULL values
in the first row
Data conversion from SQL to R: logical (as integers). Optional,
conflict with the \code{data_logical} test.
Data conversion from SQL to R: logical (as integers) with typed NULL
values.
Data conversion from SQL to R: logical (as integers) with typed NULL
values
in the first row.
Data conversion from SQL to R: A NULL value is returned as NA.
Data conversion from SQL to R: 64-bit integers.
Data conversion from SQL to R: 64-bit integers with typed NULL values.
Data conversion from SQL to R: 64-bit integers with typed NULL values
in the first row.
Data conversion from SQL to R: character.
Data conversion from SQL to R: character with typed NULL values.
Data conversion from SQL to R: character with typed NULL values
in the first row.
Data conversion from SQL to R: raw. Not all SQL dialects support the
syntax of the query used here.
Data conversion from SQL to R: raw with typed NULL values.
Data conversion from SQL to R: raw with typed NULL values
in the first row.
Data conversion from SQL to R: date, returned as integer with class.
Data conversion from SQL to R: date with typed NULL values.
Data conversion from SQL to R: date with typed NULL values
in the first row.
Data conversion from SQL to R: time.
Data conversion from SQL to R: time with typed NULL values.
Data conversion from SQL to R: time with typed NULL values
in the first row.
Data conversion from SQL to R: time (using alternative syntax with
parentheses for specifying time literals).
Data conversion from SQL to R: time (using alternative syntax with
parentheses for specifying time literals) with typed NULL values.
Data conversion from SQL to R: time (using alternative syntax with
parentheses for specifying time literals) with typed NULL values
in the first row.
Data conversion from SQL to R: timestamp.
Data conversion from SQL to R: timestamp with typed NULL values.
Data conversion from SQL to R: timestamp with typed NULL values
in the first row.
Data conversion from SQL to R: timestamp with time zone.
Data conversion from SQL to R: timestamp with time zone with typed NULL
values.
Data conversion from SQL to R: timestamp with time zone with typed NULL
values
in the first row.
Data conversion: timestamp (alternative syntax with parentheses
for specifying timestamp literals).
Data conversion: timestamp (alternative syntax with parentheses
for specifying timestamp literals) with typed NULL values.
Data conversion: timestamp (alternative syntax with parentheses
for specifying timestamp literals) with typed NULL values
in the first row.
}
}

\section{SQL}{

\subsection{\code{dbQuoteString("DBIConnection")}}{
Can quote strings, and create strings that contain quotes and spaces.
Can quote more than one string at once by passing a character vector.
}


\subsection{\code{dbQuoteIdentifier("DBIConnection")}}{
Can quote identifiers that consist of letters only.
Can quote identifiers with special characters, and create identifiers
that contain quotes and spaces.
Character vectors are treated as a single qualified identifier.
}


\subsection{\code{dbReadTable("DBIConnection")} and \code{dbWriteTable("DBIConnection")}}{
Can write the \link[datasets:iris]{datasets::iris} data as a table to the
database, but won't overwrite by default.
Can read the \link[datasets:iris]{datasets::iris} data from a database table.
Can write the \link[datasets:iris]{datasets::iris} data as a table to the
database, will overwrite if asked.
Can write the \link[datasets:iris]{datasets::iris} data as a table to the
database, will append if asked.
Cannot append to nonexisting table.
Can write the \link[datasets:iris]{datasets::iris} data as a temporary table to
the database, the table is not available in a second connection and is
gone after reconnecting.
A new table is visible in a second connection.
}


\subsection{Roundtrip tests}{
Can create tables with keywords as table and column names.
Can create tables with quotes, commas, and spaces in column names and
data.
Can create tables with integer columns.
Can create tables with numeric columns.
Can create tables with numeric columns that contain special values such
as \code{Inf} and \code{NaN}.
Can create tables with logical columns.
Can create tables with logical columns, returned as integer.
Can create tables with NULL values.
Can create tables with 64-bit columns.
Can create tables with character columns.
Can create tables with factor columns.
Can create tables with raw columns.
Can create tables with date columns.
Can create tables with timestamp columns.
Can create tables with row names.
}


\subsection{\code{dbListTables("DBIConnection")}}{
Can list the tables in the database, adding and removing tables affects
the list. Can also check existence of a table.
}


\subsection{\code{dbListFields("DBIConnection")}}{
Can list the fields for a table in the database.
}
}

\section{Meta}{

\subsection{\code{dbIsValid("DBIConnection")}}{
Only an open connection is valid.
}


\subsection{\code{dbIsValid("DBIResult")}}{
Only an open result set is valid.
}


\subsection{\code{dbGetStatement("DBIResult")}}{
SQL query can be retrieved from the result.
}


\subsection{\code{dbColumnInfo("DBIResult")}}{
Column information is correct.
}


\subsection{\code{dbGetRowCount("DBIResult")}}{
Row count information is correct.
}


\subsection{\code{dbGetRowsAffected("DBIResult")}}{
Information on affected rows is correct.
}


\subsection{\code{dbGetInfo("DBIResult")} (deprecated)}{
Return value of dbGetInfo has necessary elements
}
}

\section{Parametrised queries and statements}{

\subsection{\code{dbBind("DBIResult")}}{
Empty binding with check of
return value.
Binding of integer values raises an
error if connection is closed.
Binding of integer values with check of
return value.
Binding of integer values with too many
values.
Binding of integer values with too few
values.
Binding of integer values, repeated.
Binding of integer values with wrong names.
Binding of integer values.
Binding of numeric values.
Binding of logical values.
Binding of logical values (coerced to integer).
Binding of \code{NULL} values.
Binding of character values.
Binding of date values.
Binding of \link{POSIXct} timestamp values.
Binding of \link{POSIXlt} timestamp values.
Binding of raw values.
Binding of statements.
Repeated binding of statements.
}


\subsection{\code{dbBind("DBIResult")}}{
Binding of multi-row integer values.
Binding of multi-row integer values with zero rows.
Binding of multi-row integer values with unequal length.
Binding of multi-row statements.
}
}

\section{Transactions}{

\subsection{\code{dbBegin("DBIConnection")} and \code{dbRollback("DBIConnection")}}{
Filler
}


\subsection{\code{dbWithTransaction("DBIConnection")} and \code{dbBreak()}}{
Filler
}
}

\section{Full compliance}{

\subsection{All of DBI}{
The package defines three classes that implement the required methods.
All methods have an ellipsis \code{...} in their formals.
}


\subsection{Read-only access}{
Writing to the database fails.  (You might need to set up a separate
test context just for this test.)
}
}
\keyword{datasets}
\keyword{internal}

