\name{DoDART}
\alias{DoDART}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Main engine function for denoising algorithm based on relevance network topology
}
\description{
This is the main engine function, given the expression data and model pathway signature and desired false discovery rate, DoDART will perform denosing algorithm, which is the whole sequence of functions: 
(1) BuildRN: this builds a relevance correlation network over the model pathway signature in the data set in which the pathway activity estimate is desired. 
(2) EvalConsNet: this evaluates the consistency of the inferred network with the prior information in the model pathway signature. Only if the consistency score is higher than expected by random chance (see Pval(consist) from output: netcons), can the model signature be used to infer pathway activity. 
(3) PruneNet: this obtains the pruned, i.e consistent, network, in which any edge represents a significant correlation in gene expression whose directionality agrees with that predicted by the prior information. 
(4) MaxCon: this function builds the maximally connected pruned network from the output of PruneNet, and this subnetwork is then used for pathway activity estimation using a metric that takes the degree distribution of the nodes (genes) in the subnetwork into account. 
}
\usage{
DoDART(data.m, sign.v, fdr)
}
%- maybe also 'usage' for other objects documented here.
\arguments{

  \item{data.m}{Data matrix: rows label features, columns label samples. It is assumed that number of features is much larger than number of samples.}
  \item{sign.v}{Model pathway signature vector: elements are numeric, names of sign.v are gene names (must match rows of data.m)}
  \item{fdr}{Desired false discovery rate which determines allowed false positive in the relevance network.}

}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
  \item{sign}{model pathway signature found in data}
  \item{c}{Correlation matrix}
  \item{netsign}{A matrix of dimension 2 times number of edges in network comparing directionality of model pathway signature and that in the observed data}
  \item{netcons}{Vector summarising properties of network and the consistency with model pathway signature: nG is the number of genes, nE is the number of edges(significant correlations) of relevance network generated by function BuildRN, fE is the ratio of the number of the edges of relevance network to the number of the edges between all the genes in the signatures,
   fconsE is the ratio of the number of nE,which are consistent with the prior information (i.e. sign of the observed correlation equals to the signs predicted by the model) to the number of edges of relevance network, Pval(consist) is a p-value which reflects the significance of fconsE,it is derived from randomisations that yielded an average connectivity larger than the observed one}
  \item{consist.score}{Ratio of pruned network to unpruned network}
  \item{pradj}{Inferred relevance network adjacency matrix}
 
  
 
}
\references{
{Jiao Y, Lawler K, Patel GS, Purushotham A, Jones AF, Grigoriadis A, Ng T, Teschendorff AE. Denoising algorithm based on relevance network topology improves molecular pathway activity inference. Submitted.}

{Teschendorff AE, Gomez S, Arenas A, El-Ashry D, Schmidt M, et al. (2010) Improved prognostic classification of breast
cancer defined by antagonistic activation patterns of immune response pathway modules. BMC Cancer 10:604.}
}
\author{
Andrew E Teschendorff, Yan Jiao
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
  
### Example
### load in example data
library(DARTData)

data(data.m)
data(sign.v)
### doDART (Given the expression data and model pathway signature and desired false discovery rate, DoDART will perform denosing algorithm:running through BuildRN,EvalConsNet and PruneNet)
DART.o <- DoDART(data.m,sign.v,fdr=0.05)
### Results on consistency of inferred networks with model pathway signature
print(DART.o$netcons)
### Consistency score of inferred networks with model pathway signature
print(DART.o$consist.score)
}

\keyword{network}