% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique_island_genera.R
\name{unique_island_genera}
\alias{unique_island_genera}
\title{Determines the unique endemic genera that are included in the island clades
contained within the island_tbl object and stores them as a list with each
genus only occuring once in the first island clade it appears in}
\usage{
unique_island_genera(island_tbl)
}
\arguments{
\item{island_tbl}{An instance of the \code{Island_tbl} class.}
}
\value{
list of character vectors
}
\description{
Determines the unique endemic genera that are included in the island clades
contained within the island_tbl object and stores them as a list with each
genus only occuring once in the first island clade it appears in
}
\examples{
phylod <- create_test_phylod(test_scenario = 6)
island_tbl <- suppressWarnings(extract_island_species(
  phylod = phylod,
  extraction_method = "asr",
))
phylod <- create_test_phylod(test_scenario = 7)
island_tbl <- suppressWarnings(extract_island_species(
  phylod = phylod,
  extraction_method = "asr",
  island_tbl = island_tbl
))
unique_genera <- unique_island_genera(island_tbl = island_tbl)
}
