% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_loglik_CS.R
\name{DAISIE_logp0}
\alias{DAISIE_logp0}
\title{Computes the log probability of no species present under the DAISIE
model with clade-specific diversity-dependence}
\usage{
DAISIE_logp0(
  pars1,
  pars2,
  island_age,
  methode = "odeint::runge_kutta_fehlberg78",
  abstolint = 1e-16,
  reltolint = 1e-10
)
}
\arguments{
\item{pars1}{Vector of model parameters: \cr \cr \code{pars1[1]} corresponds
to lambda^c (cladogenesis rate) \cr \code{pars1[2]} corresponds to mu
(extinction rate) \cr \code{pars1[3]} corresponds to K (clade-level
carrying capacity) \cr \code{pars1[4]} corresponds to gamma
(immigration rate) \cr \code{pars1[5]} corresponds to lambda^a
(anagenesis rate).}

\item{pars2}{Vector of settings: \cr \cr \code{pars2[1]} corresponds to res,
the maximum number of endemics or non-endemics for which the ODE system is
solved; this must be much larger than the actual number for which the
probability needs to be calculated.) \cr \code{pars2[2]} corresponds to M,
size of the mainland pool, i.e the number of species that can potentially
colonize the island.}

\item{island_age}{the island age \cr}

\item{methode}{Method of the ODE-solver. Supported Boost \code{ODEINT}
solvers (steppers) are:
\code{"odeint::runge_kutta_cash_karp54"}
\code{"odeint::runge_kutta_fehlberg78"}
\code{"odeint::runge_kutta_dopri5"}
\code{"odeint::bulirsch_stoer"}
without \code{odeint::}-prefix, \code{\link[deSolve]{ode}} method is
assumed. The default method overall is
\code{"lsodes"} for \code{\link{DAISIE_ML_CS}()}
and \code{"ode45"} from \code{\link[deSolve]{ode}()} for
\code{\link{DAISIE_ML_IW}()}.}

\item{abstolint}{Numeric absolute tolerance of the integration}

\item{reltolint}{Numeric relative tolerance of the integration}
}
\value{
The logarithm of the probability
}
\description{
Computes the log probability of no species present under the DAISIE
model with clade-specific diversity-dependence. The output is a log value.
}
\author{
Rampal S. Etienne & Bart Haegeman
}
\keyword{internal}
