% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryD3mirt.R
\name{summary.D3mirt}
\alias{summary.D3mirt}
\title{Summary Method for S3 Objects of Class \code{D3mirt}}
\usage{
\method{summary}{D3mirt}(object, ..., digits = 4)
}
\arguments{
\item{object}{A S3 object of class \code{D3mirt}.}

\item{...}{Additional arguments.}

\item{digits}{The number of digits shown per estimate. The default is \code{digits = 4}.}
}
\value{
Tables containing \emph{a} and \emph{d} parameters, multidimensional discrimination (MDISC), multidimensional item difficulty (MDIFF), direction cosines, and degrees for vector angles for items.
If constructs were used in the estimation process, the summary function will also show tables for direction cosines, and degrees for construct vectors as well as directional discrimination (DDISC) parameters.
}
\description{
The summary method for the \code{\link[=D3mirt]{D3mirt()}} function.
}
\examples{
\dontrun{
# Call D3mirt() and create list of constructs
# The first argument can be data frame with model parameters
# or an S4 object of class 'SingleGroupClass' exported from mirt::mirt
c <- list(list(1,2,3,4,5,6,7,8,9,10),
          list(11,12,13,14),
          list(15,17,18,19,20))
g <- D3mirt(mod1, c)

# Call to summary
summary(g)

#' # Call to summary rounded off to 2 digits
summary(g, digits = 2)
}
}
\author{
Erik Forsberg
}
