% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{dimensionality_reduction}
\alias{dimensionality_reduction}
\alias{dimensionality_reduction.copy_settings,UserSession,DimensionalityReduction-method}
\alias{dimensionality_reduction.copy_settings}
\alias{dimensionality_reduction.delete,UserSession,DimensionalityReduction-method}
\alias{dimensionality_reduction.delete}
\alias{dimensionality_reduction.list,UserSession-method}
\alias{dimensionality_reduction.list}
\alias{dimensionality_reduction.new,UserSession-method}
\alias{dimensionality_reduction.new}
\alias{dimensionality_reduction.rename,UserSession,DimensionalityReduction-method}
\alias{dimensionality_reduction.rename}
\alias{dimensionality_reduction.run,UserSession,DimensionalityReduction-method}
\alias{dimensionality_reduction.run}
\alias{dimensionality_reduction.show,UserSession-method}
\alias{dimensionality_reduction.show}
\alias{dimensionality_reduction.status,UserSession,DimensionalityReduction-method}
\alias{dimensionality_reduction.status}
\alias{dimensionality_reduction.update,UserSession,DimensionalityReduction-method}
\alias{dimensionality_reduction.update}
\title{DimensionalityReduction Endpoints}
\usage{
\S4method{dimensionality_reduction.copy_settings}{UserSession,DimensionalityReduction}(
  UserSession,
  dimensionality_reduction,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{dimensionality_reduction.delete}{UserSession,DimensionalityReduction}(
  UserSession,
  dimensionality_reduction,
  timeout = UserSession@short_timeout
)

\S4method{dimensionality_reduction.list}{UserSession}(
  UserSession,
  experiment_id,
  analysis_type,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{dimensionality_reduction.new}{UserSession}(
  UserSession,
  experiment_id,
  analysis_name,
  analysis_type,
  timeout = UserSession@long_timeout
)

\S4method{dimensionality_reduction.rename}{UserSession,DimensionalityReduction}(
  UserSession,
  dimensionality_reduction,
  analysis_name,
  timeout = UserSession@short_timeout
)

\S4method{dimensionality_reduction.run}{UserSession,DimensionalityReduction}(
  UserSession,
  dimensionality_reduction,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{dimensionality_reduction.show}{UserSession}(
  UserSession,
  experiment_id,
  analysis_id,
  analysis_type,
  timeout = UserSession@short_timeout
)

\S4method{dimensionality_reduction.status}{UserSession,DimensionalityReduction}(
  UserSession,
  dimensionality_reduction,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{dimensionality_reduction.update}{UserSession,DimensionalityReduction}(
  UserSession,
  dimensionality_reduction,
  timeout = UserSession@long_timeout
)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{dimensionality_reduction}{Cytobank DimensionalityReduction object}

\item{output}{character representing the output format  \strong{[optional]}\cr
\emph{- dimensionality_reduction.list, dimensionality_reduction.run, dimensionality_reduction.status : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds  \strong{[optional]}}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{analysis_type}{character representing the Dimensionality Reduction type (tSNE-CUDA, opt-SNE, UMAP, or viSNE)}

\item{analysis_name}{character the name of the Dimensionality Reduction analysis}

\item{analysis_id}{integer representing the Dimensionality Reduction analysis ID}
}
\description{
Interact with DimensionalityReduction advanced analyses using these endpoints.
}
\details{
\code{dimensionality_reduction.copy_settings} Copy DimensionalityReduction advanced analysis
settings from an experiment and returns a DimensionalityReduction object.

\code{dimensionality_reduction.delete} Delete a DimensionalityReduction advanced analysis
from an experiment.

\code{dimensionality_reduction.list} List all DimensionalityReduction advanced analyses from an experiment.
Outputs a dataframe [default] or list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{dimensionality_reduction.new} Create a new DimensionalityReduction advanced analysis
from an experiment and returns a DimensionalityReduction object.

\code{dimensionality_reduction.rename} Rename a DimensionalityReduction advanced analysis
from an experiment and returns the new name.

\code{dimensionality_reduction.run} Run a DimensionalityReduction advanced analysis from an experiment.

\code{dimensionality_reduction.show} Show DimensionalityReduction advanced analysis details
from an experiment and returns a DimensionalityReduction object.

\code{dimensionality_reduction.status} Show the status of a DimensionalityReduction advanced analysis from an experiment.

\code{dimensionality_reduction.update} Update a DimensionalityReduction advanced analysis
from an experiment and returns the new DimensionalityReduction object.
}
\examples{
\dontrun{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")

# cyto_dimensionality_reduction refers to a DimensionalityReduction object that is created from
DimensionalityReduction endpoints
#   examples: dimensionality_reduction.new, dimensionality_reduction.show (see details section for
more)
}
\dontrun{dimensionality_reduction.copy_settings(cyto_session,
 dimensionality_reduction=cyto_dimensionality_reduction)
}
\dontrun{dimensionality_reduction.delete(cyto_session,
dimensionality_reduction=cyto_dimensionality_reduction)
}
\dontrun{# Dataframe of all DimensionalityReduction advanced analyses with all fields present
dimensionality_reduction.list(cyto_session, 22, "viSNE")

# Raw list of all DimensionalityReduction advanced analyses with all fields present
dimensionality_reduction.list(cyto_session, 22, "viSNE", output="raw")
}
\dontrun{dimensionality_reduction.new(cyto_session, 22,
analysis_name="My new DimensionalityReduction analysis", "UMAP")
}
\dontrun{dimensionality_reduction.rename(cyto_session,
dimensionality_reduction=cyto_dimensionality_reduction,
analysis_name="My updated DimensionalityReduction name")
}
\dontrun{dimensionality_reduction.run(cyto_session,
dimensionality_reduction=cyto_dimensionality_reduction)
}
\dontrun{dimensionality_reduction.show(cyto_session, 22, analysis_id=2, "opt-SNE")
}
\dontrun{dimensionality_reduction.status(cyto_session,
dimensionality_reduction=cyto_dimensionality_reduction)
}
\dontrun{dimensionality_reduction.update(cyto_session,
dimensionality_reduction=cyto_dimensionality_reduction)
}
}
