% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFit.R
\name{getSEs}
\alias{getSEs}
\title{Extract standard errors}
\usage{
getSEs(object, covariates)
}
\arguments{
\item{object}{A Cyclops model fit object}

\item{covariates}{Integer or string vector: list of covariates for which asymptotic standard errors are wanted}
}
\value{
Vector of standard error estimates
}
\description{
\code{getSEs} extracts asymptotic standard errors for specific covariates from a Cyclops model fit object.
}
\details{
This function first computes the (partial) Fisher information matrix for
just the requested covariates and then returns the square root of the diagonal elements of
the inverse of the Fisher information matrix.  These are the asymptotic standard errors
when all possible covariates are included.
When the requested covariates do not equate to all coefficients in the model,
then interpretation is more challenging.
}
\keyword{internal}

