% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLCmulti.R
\name{fitLCmulti}
\alias{fitLCmulti}
\title{Function to fit multi-population mortality models}
\usage{
fitLCmulti(
  model = c("additive", "multiplicative"),
  qxt,
  periods,
  ages,
  nPop,
  lxt = NULL
)
}
\arguments{
\item{model}{multi-population mortality model chosen to fit the mortality rates c("\code{additive}", "\code{multiplicative}"). In case you do not provide any value, the function will apply the "\code{additive}" option.}

\item{qxt}{mortality rates used to fit the additive multipopulation mortality model. This rates can be provided in matrix or in data.frame.}

\item{periods}{periods considered in the fitting in a vector way c(minyear:maxyear).}

\item{ages}{vector with the ages considered in the fitting. If the mortality rates provide from an abridged life tables, it is necessary to provide a vector with the ages, see the example.}

\item{nPop}{number of population considered for fitting.}

\item{lxt}{survivor function considered for every population, not necessary to provide.}
}
\value{
A list with class \code{"LCmulti"} including different components of the fitting process:
\itemize{
\item \code{ax} parameter that captures the average shape of the mortality curve in all considered populations.
\item \code{bx} parameter that explains the age effect x with respect to the general trend \code{kt} in the mortality rates of all considered populations.
\item \code{kt} represent the national tendency of multi-mortality populations during the period.
\item \code{Ii} gives an idea of the differences in the pattern of mortality in any region i with respect to Region 1.
\item \code{formula} additive multi-population mortality formula used to fit the mortality rates.
\item \code{model} provided the model selected in every case.
\item \code{data.used} mortality rates used to fit the data.
\item \code{qxt.real} real mortality rates.
\item \code{qxt.fitted} fitted mortality rates using the additive multi-population mortality model.
\item \code{logit.qxt.fitted} fitted mortality rates in logit way.
\item \code{Ages} provided ages to fit the data.
\item \code{Periods} provided periods to fit the periods.
\item \code{nPop} provided number of populations to fit the periods.
}
}
\description{
R function for fitting additive or multiplicative multi-population mortality model developed by: Debon et al. (2011) and Russolillo et al. (2011), respectively.
These model follows the structure of the well-known Lee-Carter model (Lee and Carter, 1992) but including an additive or multiplicative parameter to capture the behavior of each population considered.
This parameter seeks to capture the individual behavior of every population considered.
It should be mentioned that this function is developed for fitting several populations.
However, in case you only consider one population, the function will fit the single population version of the Lee-Carter model, the classical one.
}
\examples{
#The example takes more than 5 seconds because it includes
#several fitting and forecasting process and hence all
#the process is included in donttest
\donttest{
#First, we present the data that we are going to use
SpainRegions
ages <- c(0, 1, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90)

library(gnm)
library(forecast)
#ADDITIVE MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the additive multi-population mortality model
additive_Spainmales <- fitLCmulti(model = "additive",
                              qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)

additive_Spainmales

#If the user does not provide the model inside the function fitLCmult()
#the multi-population mortality model applied will be additive one.

#Once, we have fit the data, it is possible to see the ax, bx, kt, and Ii
#provided parameters for the fitting.
plot(additive_Spainmales)

#MULTIPLICATIVE MULTI-POPULATION MORTALITY MODEL
#In the case, the user wants to fit the multiplicative multi-population mortality model
multiplicative_Spainmales <- fitLCmulti(model = "multiplicative",
                              qxt = SpainRegions$qx_male,
                              periods = c(1991:2020),
                              ages = c(ages),
                              nPop = 18,
                              lxt = SpainRegions$lx_male)


multiplicative_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, kt, and It
#provided parameters for the fitting.
plot(multiplicative_Spainmales)

#LEE-CARTER FOR SINGLE-POPULATION
#As we mentioned in the details of the function, if we only provide the data
#from one-population the function fitLCmulti()
#will fit the Lee-Carter model for single populations.
LC_Spainmales <- fitLCmulti(qxt = SpainNat$qx_male,
                              periods = c(1991:2020),
                              ages = ages,
                              nPop = 1)

LC_Spainmales

#Once, we have fit the data, it is possible to see the ax, bx, and kt
#parameters provided for the single version of the LC.
plot(LC_Spainmales)
}
}
\references{
Debon, A., Montes, F., and Martinez-Ruiz, F. (2011).
Statistical methods to compare mortality for a group with non-divergent populations: an application to Spanish regions.
European Actuarial Journal, 1, 291-308.

Lee, R.D. and Carter, L.R. (1992).
Modeling and forecasting US mortality.
Journal of the American Statistical Association, 87(419), 659–671.

Russolillo, M., Giordano, G., & Haberman, S. (2011).
Extending the Lee–Carter model: a three-way decomposition.
Scandinavian Actuarial Journal, 2011(2), 96-117.
}
\seealso{
\code{\link{forecast.fitLCmulti}},
\code{\link{multipopulation_cv}}, \code{\link{multipopulation_loocv}},
\code{\link{plot.fitLCmulti}}
}
