% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom.R
\name{CustomDerivative}
\alias{CustomDerivative}
\title{Custom Derivative R6 Class}
\description{
This class provides methods to create and price custom derivatives.
}
\details{
An R6 class to create and price custom derivatives.


The class uses the Monte Carlo method for pricing. The price method simulates
the underlying asset price paths and applies the payoff function to determine
the option price.
}
\examples{
# Create a custom European call option
call_payoff <- function(price) {
  return(max(price - 100, 0))
}
option <- CustomDerivative$new(100, 100, 1, 0.2, 0.05, call_payoff)
print(option$price())
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{underlying_price}}{The underlying asset price.}

\item{\code{strike_price}}{The strike price of the option.}

\item{\code{time_to_maturity}}{Time to maturity of the option.}

\item{\code{volatility}}{The volatility of the underlying asset.}

\item{\code{risk_free_rate}}{The risk-free rate.}

\item{\code{payoff_function}}{The function that determines the payoff of the option.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CustomDerivative-new}{\code{CustomDerivative$new()}}
\item \href{#method-CustomDerivative-price}{\code{CustomDerivative$price()}}
\item \href{#method-CustomDerivative-clone}{\code{CustomDerivative$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CustomDerivative-new"></a>}}
\if{latex}{\out{\hypertarget{method-CustomDerivative-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CustomDerivative$new(
  underlying_price,
  strike_price,
  time_to_maturity,
  volatility,
  risk_free_rate,
  payoff_function
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{underlying_price}}{Initial price of the underlying asset.}

\item{\code{strike_price}}{Strike price of the option.}

\item{\code{time_to_maturity}}{Time to maturity in years.}

\item{\code{volatility}}{Volatility of the underlying asset.}

\item{\code{risk_free_rate}}{Risk-free rate (annual).}

\item{\code{payoff_function}}{A function that calculates the option payoff.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CustomDerivative-price"></a>}}
\if{latex}{\out{\hypertarget{method-CustomDerivative-price}{}}}
\subsection{Method \code{price()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CustomDerivative$price()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Numeric value representing the option price.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CustomDerivative-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CustomDerivative-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CustomDerivative$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
