/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.config;

import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.mutoss.config.Configuration;
import org.mutoss.config.SpecificConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralConfig
extends SpecificConfig {
    public static final String DISABLE = "disable";
    DecimalFormat format = null;

    GeneralConfig(Configuration conf) {
        super(conf);
    }

    public void setTempDir(String tempDir) {
        this.setProperty("tempdir", tempDir);
    }

    public String getTempDir() {
        String tmpDir = this.getProperty("tempdir", "");
        if (tmpDir.trim().equals("")) {
            tmpDir = System.getProperty("java.io.tmpdir");
        }
        return tmpDir;
    }

    public void setFontSize(int i) {
        this.setIntProperty("font.size", i);
    }

    public int getFontSize() {
        return this.getIntProperty("font.size", "12");
    }

    public void setGridSize(int grid) {
        this.setProperty("grid", "" + Math.max(grid, 1));
    }

    public int getGridSize() {
        int grid = Integer.parseInt(this.getProperty("grid", "50"));
        return Math.max(1, grid);
    }

    public void setDigits(int digit) {
        this.setProperty("Digits", "" + digit);
        this.setFormat();
    }

    public int getDigits() {
        return Integer.parseInt(this.getProperty("Digits", "4"));
    }

    public DecimalFormat getDecFormat() {
        if (this.format == null) {
            this.setFormat();
        }
        return this.format;
    }

    private void setFormat() {
        String s = "#.";
        for (int i = 0; i < this.getDigits(); ++i) {
            s = s + "#";
        }
        this.format = new DecimalFormat(s);
    }

    public int getDigitsInTables() {
        return Integer.parseInt(this.getProperty("digits.in.tables", "6"));
    }

    public boolean checkOnline() {
        return Boolean.parseBoolean(this.getProperty("checkOnline", "true"));
    }

    public void setCheckOnline(boolean checkOnline) {
        this.setProperty("checkOnline", "" + checkOnline);
    }

    public boolean haveReadGPL() {
        return Boolean.parseBoolean(this.getProperty("haveReadGPL", "false"));
    }

    public void setHaveReadGPL(boolean checkOnline) {
        this.setProperty("haveReadGPL", "" + checkOnline);
    }

    public boolean tellAboutCheckOnline() {
        return Boolean.parseBoolean(this.getProperty("tellAboutCheckOnline", "false"));
    }

    public void setTellAboutCheckOnline(boolean checkOnline) {
        this.setProperty("tellAboutCheckOnline", "" + checkOnline);
    }

    public boolean reminderNewVersion() {
        return Boolean.parseBoolean(this.getProperty("reminderNewVersion", "true"));
    }

    public void setReminderNewVersion(boolean reminderNewVersion) {
        this.setProperty("reminderNewVersion", "" + reminderNewVersion);
    }

    public void setVersionNumber(String version) {
        this.setProperty("gMCPversion", version);
    }

    public String getVersionNumber() {
        return this.getProperty("gMCPversion", "<= 0.6.0");
    }

    public void setRVersionNumber(String version) {
        this.setProperty("Rversion", version);
    }

    public String getRVersionNumber() {
        return this.getProperty("Rversion", "unknown");
    }

    public void setRandomID() {
        this.setProperty("randomID", "" + Math.abs(new Random().nextInt()));
    }

    public String getRandomID() {
        if (this.getProperty("randomID", "NOT_SET_YET").equals("NOT_SET_YET")) {
            this.setRandomID();
        }
        return this.getProperty("randomID");
    }

    public List<String> getLatestGraphs() {
        Vector<String> graphs = new Vector<String>();
        for (int i = 0; i < 4; ++i) {
            String graph = this.getProperty("saved_graph_" + i, "NOT_SAVED_YET");
            if (!graph.startsWith("R Object") && !new File(graph).exists()) continue;
            graphs.add(graph);
        }
        return graphs;
    }

    public void addGraph(String graph) {
        int i;
        for (i = 1; i < 4 && !graph.equals(this.getProperty("saved_graph_" + (i - 1), "NOT_SAVED_YET")); ++i) {
        }
        --i;
        while (i > 0) {
            String g = this.getProperty("saved_graph_" + (i - 1), "NOT_SAVED_YET");
            this.setProperty("saved_graph_" + i, g);
            --i;
        }
        this.setProperty("saved_graph_0", graph);
    }

    public int getNumberOfStarts() {
        return Integer.parseInt(this.getProperty("NumberOfStarts", "0"));
    }

    public void setNumberOfStarts(int i) {
        this.setProperty("NumberOfStarts", "" + i);
    }

    public double getAccuracy() {
        return Double.parseDouble(this.getProperty("fractionAccuracy", "0.000001"));
    }

    public void setExperimental(boolean b) {
        this.setProperty("experimentalFeatures", "" + b);
    }

    public boolean experimentalFeatures() {
        return Boolean.parseBoolean(this.getProperty("experimentalFeatures", "true"));
    }

    public void setVerbose(boolean b) {
        this.setProperty("verbose", "" + b);
    }

    public boolean verbose() {
        return Boolean.parseBoolean(this.getProperty("verbose", "true"));
    }

    public void setVariable(String variable, double value) {
        this.setProperty("Variable_" + variable, "" + value);
    }

    public double getVariable(String variable) {
        return Double.parseDouble(this.getProperty("Variable_" + variable, "0.5"));
    }

    public boolean simplify() {
        return Boolean.parseBoolean(this.getProperty("simplify", "false"));
    }

    public int getDigits2() {
        return Integer.parseInt(this.getProperty("digits2", "6"));
    }

    public void setSimplify(boolean b) {
        this.setProperty("simplify", "" + b);
    }

    public void setDigits2(int digits2) {
        this.setProperty("digits2", "" + digits2);
    }

    public Integer getNumberOfSimulations() {
        return Integer.parseInt(this.getProperty("numberOfSimulations", "10000"));
    }

    public String getTypeOfRandom() {
        return this.getProperty("typeOfRandom", "quasirandom");
    }

    public void setNumberOfSimulations(int nr) {
        this.setProperty("numberOfSimulations", "" + nr);
    }

    public void setTypeOfRandom(String type) {
        this.setProperty("typeOfRandom", "" + type);
    }

    public boolean focusEqualsEdit() {
        return Boolean.parseBoolean(this.getProperty("focusEqualsEdit", "true"));
    }

    public void setFocusEqualsEdit(boolean b) {
        this.setProperty("focusEqualsEdit", "" + b);
    }

    public boolean askWhenGraphIsNotSaved() {
        return Boolean.parseBoolean(this.getProperty("askWhenGraphIsNotSaved", "false"));
    }

    public void setAskForSaveDir(boolean b) {
        this.setProperty("askForSaveDir", "" + b);
    }

    public boolean askForSaveDir() {
        return Boolean.parseBoolean(this.getProperty("askForSaveDir", "true"));
    }

    public void setSaveDir(String saveDir) {
        this.setProperty("savedir", saveDir);
    }

    public String getSaveDir() {
        String saveDir = this.getProperty("savedir", "NOT_SET");
        if (!new File(saveDir).exists()) {
            return "NOT_SET";
        }
        return saveDir;
    }

    public Boolean failSafeMode() {
        String failsafe = System.getenv("FAILSAFE");
        if (failsafe == null) {
            return false;
        }
        return Boolean.parseBoolean(failsafe);
    }
}

