% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxphlb.phtest.R
\name{coxphlb.phtest}
\alias{coxphlb.phtest}
\title{Test the Proportional Hazards Assumption of Cox Model with Right-Censored Length-Biased Data}
\usage{
coxphlb.phtest(fit, data, spec.p = NULL, n.sim = 1000,
seed.n = round(runif(1,1,1e09)), digits = 3L)
}
\arguments{
\item{fit}{The result of fitting a Cox model, using the \code{coxphlb} function.}

\item{data}{A data frame containing the variables in the model.}

\item{spec.p}{An integer specifying which covariate to be tested. Default is  NULL. If NULL, global test is conducted. If specified, the per-variable test is conducted.}

\item{n.sim}{The number of resampling. Default is 1000.}

\item{seed.n}{An integer specifying seed number.}

\item{digits}{An integer controlling the number of digits to print.}
}
\value{
A list containing the following components:
\item{p.value}{A p-value.}
\item{}{The list is returned as an object of the \code{coxphlb.phtest} class. Objects of this class have methods for the function \code{print}. The object also contains the following: \code{spec.p}; \code{n.sim}; \code{stat.mat.t}, the test statistic; \code{sim.mat.t}, samples from the null distribution; \code{yy}, the observed ordered failure times; \code{varnames}, the variable that is tested; \code{result}, the table output.}
}
\description{
Tests the proportional hazards assumption for a Cox model fit (coxphlb).
}
\details{
The proportional hazards assumption is checked by constructing test statistics based on asymptotically mean-zero processes. The asymptotic distribution of the test statistics is approximated via resampling. This function computes the p-value by comparing the test statistics with n.sim number of resamples. If the p-value is small (e.g., <0.05), it is likely that the assumption is violated. The test can be done either per variable or globally. The global test checks if the proportional hazards assumption is valid for the overall covariates.
}
\examples{
\dontrun{
# Fit a Cox model
fit.ee <- coxphlb(Surv(a, y, delta) ~ x1 + x2, data = ExampleData1,
                 method = "EE")

# Check the Proportional Hazards Assumption
ptest1 <- coxphlb.phtest(fit.ee, data = ExampleData1, spec.p = 2,
                        seed.n = 1234)
print(ptest1)			# display the results

# Run a Global Test
ptest2 <- coxphlb.phtest(fit.ee, data = ExampleData1, spec.p = NULL,
                        seed.n=1234)
print(ptest2)			# display the results
}
}
\references{
Lee, C.H., Ning, J., and Shen, Y. Model diagnostics for proportional hazards model with length-biased data. \emph{Lifetime Data Analysis} 25(1), 79-96.
}
\seealso{
\code{\link{coxphlb}}, \code{\link{coxphlb.ftest}}, \code{\link{coxphlb.phtest.plot}}
}
