% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoxAIPW.R
\name{CoxAIPW}
\alias{CoxAIPW}
\title{CoxAIPW}
\usage{
CoxAIPW(
  data,
  Tmod = "Cox",
  Cmod = "Cox",
  PSmod = "logit",
  tau = NULL,
  k = 2,
  beta0 = 0,
  min.S = 0.05,
  min.PS = 0.1,
  weights = NULL
)
}
\arguments{
\item{data}{A matrix or dataframe object, where the first column is observed event time, second column is event indicator (1 = event, 0 = censored), third
column is a binary group indicator A (numeric 0 or 1), the other columns are baseline covariates Z.}

\item{Tmod}{working conditional model for failure time T given A,Z, currently supports values ('Cox', 'Spline', 'RSF'), corresponding to Cox PH, hazard
regression, and Random survival forest.}

\item{Cmod}{working conditional model for censoring time C given A,Z, currently supports values ('Cox', 'Spline', 'RSF'), corresponding to Cox PH, hazard
regression, and Random survival forest.}

\item{PSmod}{working model for propensity score P(A=1|Z), currently supports values ('logit','RF','twang'), corresponding to logistic regression,
random forest, and the package 'twang' (gradient boosted logistic regression).}

\item{tau}{the cutoff time of the study, which should be no less than all observed event times. Default to NULL, which sets tau to the largest observed event time.}

\item{k}{the number of folds used in cross-fitting, default to 5.}

\item{beta0}{initial value for beta in the optimization algorithm, default to 0.}

\item{min.S}{the minimum threshold for estimated survival functions P(C>t|A,Z) and P(T>t|A,Z), any estimated value below min.S is set as min.S to avoid exploding gradient. Default to 0.05}

\item{min.PS}{the minimum threshold for estimated propensity score, any estimated value below min.PS or above 1-min.PS is set to min.PS or 1-min.PS to avoid exploding gradient.
Default to 0.1}

\item{weights}{a vector of length equal to the samples size that assigns weight to each observation. Also used in Bayesian Bootstrap. Default to NULL (equal weights).}
}
\value{
a list object containing 'beta' and 'model_se'. 'beta' is the estimated log hazard ratio, 'model_se' is the model-based asymptotic standard error estimator used for inference.
}
\description{
Doubly robust estimation of two-group log hazard ratio under the Cox marginal structural model, also works with informative censoring.
}
\examples{
# run Cox AIPW on the cancer data set from survival package
data(cancer, package = 'survival')
data = data.frame(
  time = cancer$time,
  status = cancer$status - 1,
  A = cancer$sex - 1,
  age = cancer$age)
aipw = CoxAIPW(data)

# extract beta and model SE estimate
logHR = aipw$beta
modelSE = aipw$model_se
}
