% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--data_prep--filter_tools--make_quantile_function.R
\name{makeQuantileColumns}
\alias{makeQuantileColumns}
\title{Add many combo of rolling quantile columns to dataframe
have info for each quant window combo}
\usage{
makeQuantileColumns(DF, quants, windows, column = "N1")
}
\arguments{
\item{DF}{Dataframe containing columns:
site: what site the data is from
date: date variable communicating the day the measurement is from
*column: DF needs to contain a column with the same name as the string
in the variable column}

\item{quants}{vector containing the different quantiles}

\item{windows}{vector containing the different windows}

\item{column}{string name of column in DF}
}
\value{
DF with added columns
window:what window group the row is in
quant:what quantile group the row is in
ntile: a rolling quantile of the data
pastKavg.wwlog10: a mean of the last K days
}
\description{
Add many combo of rolling quantile columns to dataframe
have info for each quant window combo
}
\examples{
data("Example_data", package = "Covid19Wastewater")
Example_data$site = "madison"
makeQuantileColumns(Example_data, .5, 6, column = "geo_mean")
makeQuantileColumns(Example_data, c(.5, .75), c(2,5), column = "geo_mean")
}
