% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefnames.R
\name{renewalCoefList}
\alias{renewalCoefList}
\title{Split a vector using the prefixes of the names for grouping}
\usage{
renewalCoefList(coef)
}
\arguments{
\item{coef}{a named vector}
}
\description{
Split a vector using the prefixes of the names for grouping.
}
\details{
The names of the coefficients of renewal regression models are prefixed with
the names of the parameters to which they refer. This function splits such
vectors into a list with one component for each parameter. For example, for a
Weibull renewal regression model this will create a list with components
\code{"scale"} and \code{"shape"}.

This is a convenience function allowing users to manipulate the coefficients
related to a parameter more easily. \code{\link{renewalCoef}} can convert
this list back to a vector.
}
\seealso{
\code{\link{renewalNames}}, \code{\link{renewalCoef}}
}
