% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convCount_moments.R
\name{evCount_conv_bi}
\alias{evCount_conv_bi}
\title{renewal count expected value and variance (bi)}
\usage{
evCount_conv_bi(xmax, distPars, dist = c("weibull", "gamma", "gengamma",
  "burr"), method = c("dePril", "direct", "naive"), nsteps = 100,
  time = 1, extrap = TRUE)
}
\arguments{
\item{xmax}{unsigned integer maximum count to be used.}

\item{distPars}{TODO}

\item{dist}{TODO}

\item{method}{TODO}

\item{nsteps}{unsiged integer number of steps used to compute the integral.}

\item{time}{double time at wich to compute the probabilities. Set to 1 by
default.}

\item{extrap}{logical if \code{TRUE}, Richardson extrapolation will be
applied to improve accuracy.}
}
\value{
List named vector with ExpectedValue and Variance
}
\description{
Expcted value and varinace of the renewal count process computed numerically
}
\examples{
pwei_user <- function(tt, distP) {
    alpha <- exp(-log(distP[["scale"]]) / distP[["shape"]])
    pweibull(q = tt, scale = alpha, shape = distP[["shape"]],
             lower.tail = FALSE)
}

## ev convolution Poisson count
lambda <- 2.56
beta <- 1
distPars <- list(scale = lambda, shape = beta)

evbi <- evCount_conv_bi(20, distPars, dist = "weibull")
evu <- evCount_conv_user(20, distPars, c(2, 2), pwei_user, "dePril")

c(evbi[["ExpectedValue"]], lambda)
c(evu[["ExpectedValue"]], lambda )
c(evbi[["Variance"]], lambda     )
c(evu[["Variance"]], lambda      )

## ev convolution weibull count
lambda <- 2.56
beta <- 1.35
distPars <- list(scale = lambda, shape = beta)

evbi <- evCount_conv_bi(20, distPars, dist = "weibull")
evu <- evCount_conv_user(20, distPars, c(2.35, 2), pwei_user, "dePril")

x <- 1:20
px <- dCount_conv_bi(x, distPars, "weibull", "dePril",
                     nsteps = 100)
ev <- sum(x * px)
var <- sum(x^2 * px) - ev^2

c(evbi[["ExpectedValue"]], ev)
c(evu[["ExpectedValue"]], ev )
c(evbi[["Variance"]], var    )
c(evu[["Variance"]], var     )
}

