#find phi coefficient given tetrachoric correlation
tet2phi <- function(tetcorr, dist1, dist2) {
  if(dist1$p<=0 | dist1$p>=1) {
    stop("p for distribution 1 must be between 0 and 1.")
  }
  if(dist2$p<=0 | dist2$p>=1) {
    stop("p for distribution 2 must be between 0 and 1.")
  }
  if(is.null(dist1$skewness) | is.null(dist1$exkurtosis) | is.null(dist1$p)) {
    stop("Skewness, excess kurtosis, and p for distribution 1 must be specified.")
  }
  if(is.null(dist2$skewness) | is.null(dist2$exkurtosis) | is.null(dist2$p)) {
    stop("Skewness, excess kurtosis, and p for distribution 2 must be specified.")
  }
  
  #ensure skewness and excess kurtosis values are within possible range
  check.values<-try(validation.skewness.kurtosis(n.NN=2,
                                                 skewness.vec = c(dist1$skewness, dist2$skewness), 
                                                 kurtosis.vec = c(dist1$exkurtosis, dist2$exkurtosis)))
  if(check.values!=TRUE) {
    stop
  }
  
  #ensure that tetrachoric correlation is within a feasible range
  corr.limits<-valid.limits.BinOrdNN(plist=NULL, skew.vec=c(dist1$skewness, dist2$skewness), kurto.vec=c(dist1$exkurtosis, dist2$exkurtosis), no.bin=0, no.ord=0, no.NN=2)
  
  if(tetcorr<corr.limits$lower[2,1] | tetcorr>corr.limits$upper[2,1]) {
    stop(paste('Specified tetrachoric correlation is not within the feasible correlation range of [',
               corr.limits$lower[2,1],', ', corr.limits$upper[2,1], '] for the given distributional characteristics.', sep=''))
  }

  #find tetrachoric correlation of Z
  tetZ<-corrY2corrZ(corrY=tetcorr, 
                    skew.vec=c(dist1$skewness, dist2$skewness), 
                    kurto.vec=c(dist1$exkurtosis, dist2$exkurtosis))
  
  #find phi coefficient
  phicoef<-corrZ2phi(corrZ=tetZ, p1=dist1$p, p2=dist2$p)
  return(phicoef)
}







