% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pCorShrinkData.R
\name{pCorShrinkData}
\alias{pCorShrinkData}
\title{Adaptive shrinkage of partial correlations from a data matrix}
\usage{
pCorShrinkData(dat, permu_type = c("random", "ordered"), reg_type = "lm",
  glmnet_alpha = NULL, glmnet_nfolds = 5, thresh_up = 0.99,
  thresh_down = -0.99, maxiter = 1000, ash.control = list())
}
\arguments{
\item{dat}{The samples by features data matrix. Does not permit NA entries in X.}

\item{permu_type}{Determines if the columns of the data matrix (the features)
are permuted randomly before blocking in the ISEE algorithm
[see reference] or not.Takes one of two character input values
- "random" and "ordered" - depending on if the columns are permuted
or not.}

\item{reg_type}{Either equals \code{lm} or \code{glmnet} indicating the type of regression
used for the ISEE algorithm. If the number of samples is less
than the number of features, the \code{reg_type} automatically
reverts to \code{glmnet}.}

\item{glmnet_alpha}{The alpha parameter ( a value between 0 and 1) as in the argument \code{alpha}
in \code{glmnet} or \code{cv.glmnet} function of the glmnet
package. When \code{glmnet_alpha=1}, it assumes a Lasso
(L1) penalty on the regression and for  \code{glmnet_alpha=0},
 it assumes the ridge (L2) penalty. Only applicable when
 \code{reg_type="glmnet"}. Defaults to 1.}

\item{glmnet_nfolds}{The number of folds of cross validation carried out in
the \code{cv.glmnet} function of the glmnet package as
part of the regression model estimation when
 \code{reg_type="glmnet"}. Defaults to 5.}

\item{thresh_up}{Upper threshold for correlations. Defaults to 0.99}

\item{thresh_down}{Lower threshold for correlations. Defaults to -0.99.}

\item{maxiter}{The maximum number of iterations run for the adaptive shrinkage EM algorithm.
Default is 1000.}

\item{ash.control}{The control parameters for adaptive shrinkage}
}
\value{
Returns an adaptively shrunk version of the inverse covariance matrix and
        the partial correlation matrix estimate.
}
\description{
Performs adaptive shrinkage of the sample inverse covariances and
consequently partial correlation matrix starting from a data matrix ( no NA
permitted unlike \code{CorShrinkData}). The procedure of shrinkage combines
inverse covariance derivations from the ISEE algorithm of [Fan and Lv, 2016]
with the \code{CorShrink} formulation.
}
\references{
False Discovery Rates: A New Deal. Matthew Stephens bioRxiv 038216;
             doi: http://dx.doi.org/10.1101/038216
             Fan, Y. and Lv, J., 2016. Innovated scalable efficient estimation
             in ultra-large Gaussian graphical models. The Annals of Statistics, 44(5), pp.2098-2126.
}
\keyword{adaptive}
\keyword{correlation}
\keyword{covariance,}
\keyword{inverse}
\keyword{partial}
\keyword{shrinkage,}
