#' CorReg: see www.correg.org for article and Phd Thesis about CorReg.
#' @name CorReg-package
#' @aliases CorReg-package
#' @docType package
#' @title Algorithms for regression with correlated covariates
#' @description Sequential linear regression based on a structural equation model(explicit correlations). It permits to face highly correlated datasets.

#' @author Maintainer: Clement THERY <clement.thery@@arcelormittal.com>

#' @references coming soon. see \url{http://www.correg.org}
#' @keywords package

#' @examples
#'    #dataset generation
#'    base=mixture_generator(n=15,p=10,ratio=0.4,tp1=1,tp2=1,tp3=1,positive=0.5,
#'                           R2Y=0.8,R2=0.9,scale=TRUE,max_compl=3,lambda=1)

#'    X_appr=base$X_appr
#'    Y_appr=base$Y_appr
#'    Y_test=base$Y_test
#'    X_test=base$X_test
#'    
#'    TrueZ=base$Z#True generative structure (binary matrix)
#'    
#'    #density estimation for the MCMC
#'    mixmod=density_estimation(X=X_appr,nbclustmax=10,detailed=TRUE,mclust=TRUE)
#'    BIC_empty_vect=mixmod$BIC_vect
#'    
#'    #MCMC to find the structure
#'    res=searchZ(X=X_appr,verbose=0,reject=0,Maxiter=900,
#'                nbini=30,candidates=-1,Bic_null_vect=BIC_empty_vect,star=TRUE,p1max=15,clean=TRUE)
#'    hatZ=res$Z_opt
#'    hatBic=res$bic_opt
#'    
#'    #BIC comparison between true and found structure
#'    bicopt_vect=BicZ(X=X_appr,Z=hatZ,Bic_null_vect=BIC_empty_vect)
#'    bicopt_vrai=BicZ(X=X_appr,Z=TrueZ,Bic_null_vect=BIC_empty_vect)
#'    sum(bicopt_vect);sum(bicopt_vrai)
#'    
#'    #interpretation of found and true structure ordered by increasing R2
#'    readZ(Z=hatZ,crit="R2",X=X_appr,output="all",order=1)# <NA>line : name of subregressed covariate
#'    readZ(Z=TrueZ,crit="R2",X=X_appr,output="all",order=1)# <NA>line : name of subregressed covariate
#'    
#'    #Structure comparison
#'    compZ=compare_struct(trueZ=TrueZ,Zalgo=hatZ)#qualitative comparison
#'    
#'    #Regression coefficients estimation
#'     select="NULL"
#'    resY=correg(X=X_appr,Y=Y_appr,Z=hatZ,compl=TRUE,expl=TRUE,pred=TRUE,
#'                select=select,K=10,returning=TRUE)
#'    
#'    MSE_complete=MSE_loc(Y=Y_test,X=X_test,intercept=TRUE,A=resY$compl$A)
#'    MSE_explicative=MSE_loc(Y=Y_test,X=X_test,intercept=TRUE,A=resY$expl$A)
#'    MSE_predictive=MSE_loc(Y=Y_test,X=X_test,intercept=TRUE,A=resY$pred$A)
#'    MSE_vrai=MSE_loc(Y=Y_test,X=X_test,intercept=TRUE,A=base$A)
#'    
#'    MSE=data.frame(MSE_complete,MSE_explicative,MSE_predictive,MSE_vrai)
#'    MSE#estimated structure
#'    compZ$true_left;compZ$false_left
#'    \dontrun{
#'   barplot(as.matrix(MSE),main="MSE on validation dataset", sub=paste("select=",select))
#'   abline(h=MSE_complete,col="red")
#'    }
NULL
