% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_sp_copula.R
\name{ic_sp_copula}
\alias{ic_sp_copula}
\title{Copula regression models with semiparametric margins for bivariate interval-censored data}
\source{
Tao Sun, Yi Liu, Richard J. Cook, Wei Chen and Ying Ding (2018).
Copula-based Score Test for Bivariate Time-to-event Data, with Application to a Genetic Study of AMD Progression.
\emph{Lifetime Data Analysis} doi:10.1007/s10985-018-09459-5. \cr
Tao Sun and Ying Ding (2019).
Copula-based Semiparametric Transformation Model for Bivariate Data Under General Interval Censoring.
http://arxiv.org/abs/1901.01918.
}
\usage{
ic_sp_copula(data, var_list, l = 0, u, copula = "Copula2", m = 3,
  r = 3, method = "Newton", iter = 300, stepsize = 1e-05,
  hes = TRUE)
}
\arguments{
\item{data}{a data frame; must have id (subject id), ind (1,2 for two units in each subject),
Left (0 if left-censoring), Right (Inf if right-censoring), status (0 for right-censoring, 1 for interval-censoring or left-censoring), and covariates by column.}

\item{var_list}{the list of covariates to be fitted into the copula model.}

\item{l}{the left bound for all Left and Right endpoints of observed finite intervals; default is 0.}

\item{u}{the right bound for all Left and Right endpoints of observed finite intervalsl; has to be a finite value}

\item{copula}{Types of copula model.}

\item{m}{integer, degree of Berstein polynomials (assume same phi for two margins, leading to m+1 Berstein coefficients parameters).}

\item{r}{postive transformation parameter for the semi-parametric linear transformation model.}

\item{method}{optimization method; default is "Newton" using nlm; Alternatives are methods in the general optim function, such as "CG" (Conjugate Gradient).}

\item{iter}{number of iterations allowed for method = "Newton"; default is 300.}

\item{stepsize}{size of optimization step for method = "Newton"; default is 1e-5.}

\item{hes}{default = T for hessian calculation; if LRT is desired, can set hes = FALSE to save time.}
}
\value{
a CopulaCenR object summarizing the model. Can be used as an input to general S3 methods including
summary, plot, lines, coef, logLik, predict.
}
\description{
Fits a copula model with semiparametric margins for bivariate interval-censored data.
}
\details{
The supported copula models are "Clayton", "Gumbel", "Frank", "AMH", "Joe", "Copula2".
The "Copula2" model is a two-parameter copula model that incorporates Clayton and Gumbel as special cases.
The marginal semiparametric transformation models are built based on Bernstein polynomials.
The parameter r (a positive number) decides the model assumption, with r = 1 for proportional hazards and 3 for proportional odds.
The parameter m (a positive integer) is the degree of Bernstein polynomials, with default m = 4.
Usually, m and r are selected based on the AIC value, which is provided after fitting the copula model. \cr

The input data must be a data frame. with columns id (sample id), ind (1,2 for the two units from the same id),
Left (0 if left-censoring), Right (Inf if right-censoring), status (0 for right-censoring, 1 for interval-censoring or left-censoring), and covariates. Do not allow Left == Right. \cr

Optimization methods can be "Newton" (from nlm) and all methods from optim, such as "Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN". "Brent" is not allowed due to more than one estimators.
}
\examples{
# fit a Copula2-Semiparametric model
data(AREDS)
copula2_sp <- ic_sp_copula(data = AREDS, copula = "Copula2", l = 0, u = 15,
              m = 4, r = 3, var_list = c("ENROLLAGE","rs2284665","SevScaleBL"),
              iter = 300, stepsize = 1e-6, method = "Newton")
summary(copula2_sp)
}
