% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_wmts.r
\name{cms_wmts_details}
\alias{cms_wmts_details}
\alias{addCmsWMTSTiles}
\alias{cms_wmts_get_capabilities}
\title{Obtain a WMTS entry for specific Copernicus marine products and add to a leaflet map}
\usage{
cms_wmts_details(product, layer, variable)

addCmsWMTSTiles(
  map,
  product,
  layer,
  variable,
  tilematrixset = "EPSG:3857",
  options = leaflet::WMSTileOptions(format = "image/png", transparent = TRUE),
  ...
)

cms_wmts_get_capabilities(product, layer, variable, type = c("list", "xml"))
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{cms_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{cms_product_details}}.}

\item{variable}{The name of a desired variable in a specific layer of a product (type \code{character}).
Can be obtained with \code{\link{cms_product_details}}.}

\item{map}{A map widget object created from \code{\link[leaflet:leaflet]{leaflet::leaflet()}}}

\item{tilematrixset}{A \code{character} string representing the tilematrixset to be used. In
many cases \code{"EPSG:3857"} (Pseudo-Mercator) or \code{"EPSG:4326"} (World Geodetic System 1984)
are available, but should be checked with \code{cms_wmts_details}.}

\item{options}{Passed on to \code{\link[leaflet:map-layers]{leaflet::addWMSTiles()}}.}

\item{...}{Passed on to \code{\link[leaflet:map-layers]{leaflet::addWMSTiles()}}.}

\item{type}{A \code{character} string indicating whether the capabilities should be returned
as \code{"list"} (default) or \code{"xml"} (\code{\link[xml2:xml_new_document]{xml2::xml_new_document()}}).}
}
\value{
\code{cms_wmts_details} returns a tibble with detains on the WMTS service.
\code{cms_wmts_getcapabilities} returns either a \code{list} or \code{xml_document} depending on the value
of \code{type}. \code{AddCmsWMTSTiles} returns a \code{leaflet} \code{map} updated with the requested tiles.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Functions for retrieving Web Map Tile Services information for
specific products, layers and variables and add them to a \code{leaflet} map.
}
\examples{
wmts_details <-
  cms_wmts_details(
    product  = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
    layer    = "cmems_mod_glo_phy-thetao_anfc_0.083deg_P1D-m",
    variable = "thetao"
  )

cms_wmts_get_capabilities("GLOBAL_ANALYSISFORECAST_PHY_001_024")

if (interactive() && nrow(wmts_details) > 0) {
  leaflet::leaflet() |>
    leaflet::setView(lng = 3, lat = 54, zoom = 4) |>
    leaflet::addProviderTiles("Esri.WorldImagery") |>
    addCmsWMTSTiles(
      product  = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
      layer    = "cmems_mod_glo_phy-thetao_anfc_0.083deg_P1D-m",
      variable = "thetao")
}
}
\author{
Pepijn de Vries
}
