% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{aoi_geom_save_tif_matches}
\alias{aoi_geom_save_tif_matches}
\title{Download the elevation .tif files that intersect with an input sf-AOI}
\usage{
aoi_geom_save_tif_matches(
  sf_or_file,
  dir_save_tifs,
  resolution = 90,
  crs_value = 4326,
  threads = parallel::detectCores(),
  verbose = FALSE
)
}
\arguments{
\item{sf_or_file}{either an 'sf' or a .geojson file specifying the AOI (Area of Interest) for which the DEM files should be downloaded}

\item{dir_save_tifs}{a valid path to a directory where the .tif files should be saved}

\item{resolution}{an integer value specifying the elevation resolution. The Copernicus DEM data currently includes 90 meter and 30 meter resolution DEM's}

\item{crs_value}{an integer value specifying the CRS value of the DEM's which is by default 4326}

\item{threads}{an integer value specifying the number of threads to use mainly to read the .csv files from the 'inst' directory}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
a list object of length 2
}
\description{
Download the elevation .tif files that intersect with an input sf-AOI
}
\details{
Based on a sample of images that I downloaded for the 90 meter resolution each file is approx. 5 MB which means in total I'll have to download 130 GB of
data (for more than 20.000 files of all land areas worldwide), therefore download the data based on intersection of the input AOI data and the existing tile-grid of the DEM

The 30 meter resolution .tif images are bigger in size but visually better (1.7 MB compared to 13 MB - the time to download is approx. 20 sec. compared to 1 min. and 10 sec. for a sample use case)
}
\examples{

\dontrun{

#....................................
# create a directory to save the .tif
# files and a WKT of a samplel AOI
#....................................

DIR_SAVE = file.path(Sys.getenv('HOME'), 'DIR_SAVE_DEM')
if (!dir.exists(DIR_SAVE)) dir.create(DIR_SAVE)

WKT='POLYGON((61.5234 27.0591, 63.6328 27.0591, 63.6328 28.1495, 61.5234 28.1495, 61.5234 27.0591))'

sf_obj = sf::st_as_sfc(WKT, crs = 4326)
sf_obj = sf::st_make_valid(sf_obj)

#.............
# 90 meter DEM
#.............

save_matches = CopernicusDEM::aoi_geom_save_tif_matches(sf_or_file = sf_obj,
                                                        dir_save_tifs = DIR_SAVE,
                                                        resolution = 90,
                                                        crs_value = 4326,
                                                        threads = parallel::detectCores(),
                                                        verbose = TRUE)

#.............
# 30 meter DEM
#.............

save_matches = CopernicusDEM::aoi_geom_save_tif_matches(sf_or_file = sf_obj,
                                                        dir_save_tifs = DIR_SAVE,
                                                        resolution = 30,
                                                        crs_value = 4326,
                                                        threads = parallel::detectCores(),
                                                        verbose = TRUE)
}
}
\references{
https://registry.opendata.aws/copernicus-dem/

https://copernicus-dem-30m.s3.amazonaws.com/readme.html
}
