% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidClaimsVector}
\alias{stopOnInvalidClaimsVector}
\title{Parameter Function stopOnInvalidClaimsVector}
\usage{
stopOnInvalidClaimsVector(paramCheckResult, n, d)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{n}{represents the number of players}

\item{d}{numeric vector which contains the claims of each player in a bankruptcy game}
}
\description{
stopOnInvalidClaimsVector checks if claims vector
 in a bankruptcy game is specified correctly.
 Validation result gets stored to object paramCheckResult 
 in case an error occured and causes stop otherwise.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1160 \tab Number of claims must equal the number of players in the bankruptcy game! \cr
1161 \tab Invalid claims vector as d must be numeric }
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
validClaimsVector = c(100,150,200)
stopOnInvalidClaimsVector(paramCheckResult, n=3, d=validClaimsVector)

}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInconsistentEstateAndClaimsVector}},
  \code{\link{stopOnInvalidAllocation}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidCoalitionS}},
  \code{\link{stopOnInvalidDictator}},
  \code{\link{stopOnInvalidEstate}},
  \code{\link{stopOnInvalidGameVector}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidIndex}},
  \code{\link{stopOnInvalidLeftRightGloveGame}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnInvalidWeightVector}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
\concept{ParameterChecks_CoopGame}
