% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NevisonConcept.R
\name{nevisonIndex}
\alias{nevisonIndex}
\title{Compute Nevison index}
\usage{
nevisonIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Nevison index for a specified simple game
}
\description{
Calculates the Nevison index for a specified simple TU game.
Note that in general the Nevison index is not an efficient vector, 
i.e. the sum of its entries is not always 1.
Hence no drawing routine for the Nevison index is provided.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
nevisonIndex(v) 

}
\references{
Nevison, H. (1979) "Structural power and satisfaction in simple games", In: Applied Game Theory, Springer, pp. 39--57
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
