% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertyWeaklyConstantSum.R
\name{isWeaklyConstantSumGame}
\alias{isWeaklyConstantSumGame}
\alias{isWeaklyConstantsumGame}
\title{Check if game is weakly constant-sum}
\usage{
isWeaklyConstantSumGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is weakly constant-sum, else \code{FALSE}.
}
\description{
Checks if a TU game with n players is weakly constant-sum. \cr
In a weakly constant-sum game for any singleton coalition 
the sums of the values of that singleton coalition 
and its complement equal the value of 
the grand coalition \code{N}.
}
\examples{
library(CoopGame)
v1=c(0,0,0,2,2,2,2) 
isWeaklyConstantSumGame(v1)

\donttest{
#Example of a game that is not weakly constant-sum 
library(CoopGame)
v2=c(0,0,0,40,30,130,100) 
isWeaklyConstantSumGame(v2)

#Another example of a weakly constant-sum game
library(CoopGame)
v3=c(1,1,1,2, 7,7,7,7,7,7, 2,3,3,3, 4)
isWeaklyConstantSumGame(v3)
}

}
\references{
Staudacher J. and Anwander J. (2019) "Conditions for the uniqueness of the Gately point for cooperative games", arXiv preprint, arXiv:1901.01485, 10 pages.
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
