% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertyConvexity.R
\name{isConvexGame}
\alias{isConvexGame}
\title{Check if game is convex}
\usage{
isConvexGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is convex, else \code{FALSE}
}
\description{
isConvexGame checks if a TU game is convex.
A TU game is convex if and only if each player's marginal 
contribution to any coalition is monotone nondecreasing 
with respect to set-theoretic inclusion.
}
\examples{
library(CoopGame)
isConvexGame(c(0,0,0,1,1,1,5))

\donttest{
#Example of a convex game with three players
library(CoopGame) 
v=c(0,0,0,1,2,1,4)
isConvexGame(v)

#Example of a nonconvex game
library(CoopGame) 
v=c(1:7)
isConvexGame(v)
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 10

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, p. 329

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 717--718

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, pp. 260--261
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
