% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GameVector.R
\name{getDualGameVector}
\alias{getDualGameVector}
\title{Compute dual game vector}
\usage{
getDualGameVector(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Numeric vector of length (2^n)-1 representing the dual game.
}
\description{
Computes the dual game for a given TU game 
with n players specified by a game vector.
}
\examples{
library(CoopGame)
v<-unanimityGameVector(4,c(1,2))
getDualGameVector(v)

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 125

Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 7

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 737
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
